/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.file.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.metaobjects.constraint.CustomConstraint;
import com.metaobjects.constraint.PlacementConstraint;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.json.JsonDirectWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import com.metaobjects.registry.TypeDefinition;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataFileSchemaWriter
extends JsonDirectWriter<MetaDataFileSchemaWriter> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataFileSchemaWriter.class);
    private String schemaVersion = "https://json-schema.org/draft/2020-12/schema";
    private String schemaId;
    private String title;
    private String description;
    private MetaDataRegistry typeRegistry = MetaDataRegistry.getInstance();
    private List<PlacementConstraint> placementConstraints = new ArrayList<PlacementConstraint>();
    private List<CustomConstraint> validationConstraints = new ArrayList<CustomConstraint>();

    public MetaDataFileSchemaWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader, out);
        log.info("Initialized registry-driven schema writer with {} registered types", (Object)this.typeRegistry.getRegisteredTypes().size());
    }

    public MetaDataFileSchemaWriter withSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public MetaDataFileSchemaWriter withSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public MetaDataFileSchemaWriter withTitle(String title) {
        this.title = title;
        return this;
    }

    public MetaDataFileSchemaWriter withDescription(String description) {
        this.description = description;
        return this;
    }

    @Deprecated
    public MetaDataFileSchemaWriter addConstraintFile(String constraintFile) {
        log.warn("Constraint files are deprecated - using registry-based type discovery instead");
        return this;
    }

    @Override
    public String toString() {
        return "MetaDataFileSchemaWriter{schemaVersion='" + this.schemaVersion + "', schemaId='" + this.schemaId + "', title='" + this.title + "', description='" + this.description + "', registeredTypes=" + this.typeRegistry.getRegisteredTypes().size() + "}";
    }

    @Override
    public void writeJson() throws GeneratorIOException {
        try {
            this.loadConstraintDefinitions();
            JsonObject schema = this.generateMetaDataFileSchema();
            this.setJsonObject(schema);
        }
        catch (Exception e) {
            throw new GeneratorIOException(this, "Failed to generate metadata file JSON schema", e);
        }
    }

    private void loadConstraintDefinitions() {
        log.info("Loading registry data for schema generation: {} types, {} constraints", (Object)this.typeRegistry.getRegisteredTypes().size(), (Object)this.typeRegistry.getAllValidationConstraints().size());
        this.placementConstraints = this.typeRegistry.getPlacementValidationConstraints();
        this.validationConstraints = this.typeRegistry.getFieldValidationConstraints();
        log.debug("Registry types: {}", (Object)this.typeRegistry.getRegisteredTypeNames());
    }

    private JsonObject generateMetaDataFileSchema() {
        JsonObject schema = new JsonObject();
        schema.addProperty("$schema", this.schemaVersion);
        if (this.schemaId != null) {
            schema.addProperty("$id", this.schemaId);
        }
        schema.addProperty("title", this.title != null ? this.title : "MetaData File JSON Schema");
        schema.addProperty("description", this.description != null ? this.description : "JSON Schema for validating MetaData file structure and constraints");
        schema.addProperty("type", "object");
        JsonObject properties = new JsonObject();
        properties.add("metadata", (JsonElement)this.createMetaDataObjectSchema());
        schema.add("properties", (JsonElement)properties);
        JsonArray required = new JsonArray();
        required.add("metadata");
        schema.add("required", (JsonElement)required);
        schema.add("$defs", (JsonElement)this.createMetaDataDefinitions());
        return schema;
    }

    private JsonObject createMetaDataObjectSchema() {
        JsonObject metaDataSchema = new JsonObject();
        metaDataSchema.addProperty("type", "object");
        JsonObject properties = new JsonObject();
        JsonObject packageSchema = new JsonObject();
        packageSchema.addProperty("type", "string");
        packageSchema.addProperty("description", "Package name for the metadata");
        properties.add("package", (JsonElement)packageSchema);
        JsonObject childrenSchema = new JsonObject();
        childrenSchema.addProperty("type", "array");
        childrenSchema.addProperty("description", "Array of metadata children (objects, fields, etc.)");
        JsonObject childrenItems = new JsonObject();
        childrenItems.add("$ref", (JsonElement)new JsonPrimitive("#/$defs/MetaDataChild"));
        childrenSchema.add("items", (JsonElement)childrenItems);
        properties.add("children", (JsonElement)childrenSchema);
        metaDataSchema.add("properties", (JsonElement)properties);
        JsonArray required = new JsonArray();
        required.add("children");
        metaDataSchema.add("required", (JsonElement)required);
        return metaDataSchema;
    }

    private JsonObject createMetaDataDefinitions() {
        JsonObject definitions = new JsonObject();
        definitions.add("MetaDataChild", (JsonElement)this.createMetaDataChildSchema());
        definitions.add("NameConstraints", (JsonElement)this.createNameConstraintsSchema());
        this.generateTypeSpecificDefinitions(definitions);
        return definitions;
    }

    private JsonObject createMetaDataChildSchema() {
        JsonObject childSchema = new JsonObject();
        childSchema.addProperty("type", "object");
        childSchema.addProperty("description", "A metadata child element (dynamic types from registry)");
        JsonArray oneOf = new JsonArray();
        Set primaryTypes = this.typeRegistry.getAllTypeDefinitions().stream().map(TypeDefinition::getType).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String primaryType : primaryTypes) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty("type", "object");
            JsonObject properties = new JsonObject();
            JsonObject typeRef = new JsonObject();
            typeRef.add("$ref", (JsonElement)new JsonPrimitive("#/$defs/" + this.capitalizeFirstLetter(primaryType)));
            properties.add(primaryType, (JsonElement)typeRef);
            wrapper.add("properties", (JsonElement)properties);
            JsonArray required = new JsonArray();
            required.add(primaryType);
            wrapper.add("required", (JsonElement)required);
            oneOf.add((JsonElement)wrapper);
        }
        childSchema.add("oneOf", (JsonElement)oneOf);
        log.debug("Generated dynamic child schema for types: {}", (Object)primaryTypes);
        return childSchema;
    }

    private void generateTypeSpecificDefinitions(JsonObject definitions) {
        Map<String, List<TypeDefinition>> typeGroups = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType));
        for (Map.Entry<String, List<TypeDefinition>> entry : typeGroups.entrySet()) {
            String primaryType = entry.getKey();
            List<TypeDefinition> typeDefs = entry.getValue();
            JsonObject typeSchema = this.createPrimaryTypeSchema(primaryType, typeDefs);
            definitions.add(this.capitalizeFirstLetter(primaryType), (JsonElement)typeSchema);
            log.debug("Generated schema for type '{}' with {} subtypes", (Object)primaryType, (Object)typeDefs.size());
        }
    }

    private JsonObject createPrimaryTypeSchema(String primaryType, List<TypeDefinition> typeDefs) {
        JsonObject schema = new JsonObject();
        schema.addProperty("type", "object");
        schema.addProperty("description", String.format("%s definition with %d registered subtypes", this.capitalizeFirstLetter(primaryType), typeDefs.size()));
        JsonObject properties = new JsonObject();
        properties.add("name", (JsonElement)this.createNameConstraintsSchema());
        JsonObject typeSchema = new JsonObject();
        typeSchema.addProperty("type", "string");
        typeSchema.addProperty("description", String.format("%s subtype", this.capitalizeFirstLetter(primaryType)));
        JsonArray typeEnum = new JsonArray();
        Set subTypes = typeDefs.stream().map(TypeDefinition::getSubType).collect(Collectors.toCollection(LinkedHashSet::new));
        subTypes.forEach(arg_0 -> ((JsonArray)typeEnum).add(arg_0));
        typeSchema.add("enum", (JsonElement)typeEnum);
        properties.add("subType", (JsonElement)typeSchema);
        if (this.hasChildRequirements(typeDefs)) {
            JsonObject childrenSchema = new JsonObject();
            childrenSchema.addProperty("type", "array");
            JsonObject childrenItems = new JsonObject();
            childrenItems.add("$ref", (JsonElement)new JsonPrimitive("#/$defs/MetaDataChild"));
            childrenSchema.add("items", (JsonElement)childrenItems);
            properties.add("children", (JsonElement)childrenSchema);
        }
        schema.add("properties", (JsonElement)properties);
        JsonObject patternProperties = new JsonObject();
        patternProperties.add("^@[a-zA-Z][a-zA-Z0-9_]*$", (JsonElement)this.createInlineAttributeValueSchema());
        schema.add("patternProperties", (JsonElement)patternProperties);
        JsonArray required = new JsonArray();
        required.add("name");
        required.add("subType");
        schema.add("required", (JsonElement)required);
        return schema;
    }

    private JsonObject createNameConstraintsSchema() {
        JsonObject nameSchema = new JsonObject();
        nameSchema.addProperty("type", "string");
        nameSchema.addProperty("description", "Name following MetaData naming constraints");
        String jsonSchemaPattern = "^[a-zA-Z][a-zA-Z0-9_]*$".replaceAll("^\\^|\\$$", "");
        nameSchema.addProperty("pattern", jsonSchemaPattern);
        nameSchema.addProperty("minLength", (Number)1);
        nameSchema.addProperty("maxLength", (Number)64);
        return nameSchema;
    }

    private JsonObject createInlineAttributeValueSchema() {
        JsonObject valueSchema = new JsonObject();
        valueSchema.addProperty("description", "Inline attribute value (@ prefixed) - supports boolean, number, string, or array");
        JsonArray anyOf = new JsonArray();
        JsonObject boolSchema = new JsonObject();
        boolSchema.addProperty("type", "boolean");
        anyOf.add((JsonElement)boolSchema);
        JsonObject numberSchema = new JsonObject();
        numberSchema.addProperty("type", "number");
        anyOf.add((JsonElement)numberSchema);
        JsonObject stringSchema = new JsonObject();
        stringSchema.addProperty("type", "string");
        anyOf.add((JsonElement)stringSchema);
        JsonObject arraySchema = new JsonObject();
        arraySchema.addProperty("type", "array");
        JsonObject arrayItems = new JsonObject();
        arrayItems.addProperty("type", "string");
        arraySchema.add("items", (JsonElement)arrayItems);
        anyOf.add((JsonElement)arraySchema);
        valueSchema.add("anyOf", (JsonElement)anyOf);
        return valueSchema;
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private boolean hasChildRequirements(List<TypeDefinition> typeDefs) {
        return typeDefs.stream().anyMatch(def -> !def.getChildRequirements().isEmpty());
    }
}

