/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.ai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.metaobjects.generator.direct.metadata.ai.MetaDataAIDocumentationGenerator;
import com.metaobjects.generator.direct.metadata.ai.MetaDataAIDocumentationWriter;
import com.metaobjects.registry.MetaDataRegistry;
import com.metaobjects.registry.TypeDefinition;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAIDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(MetaDataAIDocumentationTest.class);
    private MetaDataRegistry registry;
    private ByteArrayOutputStream outputStream;

    @Before
    public void setUp() {
        this.registry = MetaDataRegistry.getInstance();
        this.outputStream = new ByteArrayOutputStream();
        try {
            Class.forName("com.metaobjects.field.StringField");
            Class.forName("com.metaobjects.field.IntegerField");
            Class.forName("com.metaobjects.object.MetaObject");
        }
        catch (ClassNotFoundException e) {
            log.warn("Some core types not available for testing: {}", (Object)e.getMessage());
        }
        log.info("Test setup completed with {} registered types", (Object)this.registry.getRegisteredTypes().size());
    }

    @Test
    public void testAIDocumentationGeneration() throws Exception {
        MetaDataAIDocumentationGenerator generator = new MetaDataAIDocumentationGenerator();
        generator.setIncludeInheritance(true);
        generator.setIncludeExtensionGuidance(true);
        generator.setIncludeCrossLanguageInfo(true);
        log.info("Testing AI documentation generation with configuration: {}", (Object)generator.getConfigurationSummary());
        MetaDataAIDocumentationWriter writer = new MetaDataAIDocumentationWriter(null, (OutputStream)this.outputStream);
        writer.withInheritance(true).withExtensionGuidance(true).withCrossLanguageInfo(true);
        writer.writeJson();
        writer.close();
        String jsonOutput = this.outputStream.toString();
        Assert.assertNotNull((String)"Documentation should be generated", (Object)jsonOutput);
        Assert.assertFalse((String)"Documentation should not be empty", (boolean)jsonOutput.trim().isEmpty());
        log.info("Generated AI documentation ({} bytes)", (Object)jsonOutput.length());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject doc = (JsonObject)gson.fromJson(jsonOutput, JsonObject.class);
        Assert.assertTrue((String)"Should have documentation info", (boolean)doc.has("documentationInfo"));
        Assert.assertTrue((String)"Should have inheritance hierarchy", (boolean)doc.has("inheritanceHierarchy"));
        Assert.assertTrue((String)"Should have type catalog", (boolean)doc.has("typeCatalog"));
        Assert.assertTrue((String)"Should have extension guidance", (boolean)doc.has("extensionGuidance"));
        Assert.assertTrue((String)"Should have implementation mapping", (boolean)doc.has("implementationMapping"));
        Assert.assertTrue((String)"Should have cross-language support", (boolean)doc.has("crossLanguageSupport"));
        JsonObject docInfo = doc.getAsJsonObject("documentationInfo");
        Assert.assertTrue((String)"Should be marked as AI optimized", (boolean)docInfo.get("aiOptimized").getAsBoolean());
        Assert.assertTrue((String)"Should have inheritance support", (boolean)docInfo.get("inheritanceSupport").getAsBoolean());
        Assert.assertTrue((String)"Should have positive type count", (docInfo.get("totalTypes").getAsInt() > 0 ? 1 : 0) != 0);
        JsonObject typeCatalog = doc.getAsJsonObject("typeCatalog");
        Assert.assertTrue((String)"Type catalog should have entries", (typeCatalog.size() > 0 ? 1 : 0) != 0);
        log.info("Sample AI documentation structure:\n{}", (Object)gson.toJson((JsonElement)doc.getAsJsonObject("documentationInfo")));
        JsonObject extensionGuidance = doc.getAsJsonObject("extensionGuidance");
        Assert.assertTrue((String)"Should have extension patterns", (boolean)extensionGuidance.has("extensionPatterns"));
        Assert.assertTrue((String)"Should have extension points", (boolean)extensionGuidance.has("extensionPoints"));
        Assert.assertTrue((String)"Should have registration example", (boolean)extensionGuidance.has("registrationExample"));
        log.info("AI documentation generation test completed successfully");
    }

    @Test
    public void testRegistryTypeDiscovery() {
        int typeCount = this.registry.getRegisteredTypes().size();
        log.info("Registry contains {} types: {}", (Object)typeCount, (Object)this.registry.getRegisteredTypeNames());
        Assert.assertTrue((String)"Should have at least some core types registered", (typeCount > 0 ? 1 : 0) != 0);
        boolean hasFieldTypes = this.registry.getRegisteredTypeNames().stream().anyMatch(name -> name.startsWith("field."));
        boolean hasObjectTypes = this.registry.getRegisteredTypeNames().stream().anyMatch(name -> name.startsWith("object."));
        log.info("Has field types: {}, Has object types: {}", (Object)hasFieldTypes, (Object)hasObjectTypes);
        Assert.assertTrue((String)"Registry should contain registered types for documentation generation", (typeCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInheritanceAnalysis() {
        long inheritedTypes = this.registry.getAllTypeDefinitions().stream().filter(TypeDefinition::hasParent).count();
        log.info("Found {} types with inheritance relationships", (Object)inheritedTypes);
        this.registry.getAllTypeDefinitions().stream().filter(TypeDefinition::hasParent).limit(3L).forEach(def -> log.info("Inheritance example: {} inherits from {}", (Object)def.getQualifiedName(), (Object)def.getParentQualifiedName()));
    }

    @Test
    public void testGeneratorConfiguration() {
        MetaDataAIDocumentationGenerator generator = new MetaDataAIDocumentationGenerator();
        generator.setVersion("test-version");
        generator.setIncludeInheritance(false);
        generator.setIncludeImplementationDetails(false);
        generator.setIncludeExtensionGuidance(false);
        generator.setIncludeCrossLanguageInfo(true);
        String summary = generator.getConfigurationSummary();
        Assert.assertNotNull((String)"Configuration summary should not be null", (Object)summary);
        Assert.assertTrue((String)"Should include version", (boolean)summary.contains("test-version"));
        Assert.assertTrue((String)"Should reflect disabled inheritance", (boolean)summary.contains("Inheritance Analysis: Disabled"));
        Assert.assertTrue((String)"Should reflect enabled cross-language", (boolean)summary.contains("Cross-Language Info: Enabled"));
        log.info("Generator configuration test: {}", (Object)summary);
    }
}

