/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.util;

import com.metaobjects.generator.util.GeneratorUtil;
import org.junit.Assert;
import org.junit.Test;

public class GeneratorUtilTest {
    @Test
    public void testFilterMatching() {
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::PrimaryStore"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::???????Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::@Store"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::??????Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*::*Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::good::PrimaryStore", (String)"acme::*Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::good::PrimaryStore", (String)"acme::*::*Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::@::@Store"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::bad::PrimaryStore", (String)"acme::@::@Store"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::bad::PrimaryStore", (String)"acme::store::@Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::Pri@Store"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::store::Pri*Store"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*::*StoreZ"));
        Assert.assertTrue((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*::*Store*"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*::*Store@"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"acme::*::*Store?"));
        Assert.assertFalse((boolean)GeneratorUtil.filterByName((String)"acme::store::PrimaryStore", (String)"bobs::*"));
    }

    @Test
    public void testToRelativePackage() {
        Assert.assertEquals((Object)"::ext::", (Object)GeneratorUtil.toRelativePackage((String)"produce::v1::container", (String)"produce::v1::container::ext"));
        Assert.assertEquals((Object)"global::v1::common::", (Object)GeneratorUtil.toRelativePackage((String)"produce::v1::container", (String)"global::v1::common"));
        Assert.assertEquals((Object)"..::fruit::", (Object)GeneratorUtil.toRelativePackage((String)"produce::v1::container", (String)"produce::v1::fruit"));
        Assert.assertEquals((Object)"", (Object)GeneratorUtil.toRelativePackage((String)"", (String)""));
        Assert.assertEquals((Object)"acme::store::", (Object)GeneratorUtil.toRelativePackage((String)"", (String)"acme::store"));
        Assert.assertEquals((Object)"", (Object)GeneratorUtil.toRelativePackage((String)"acme::store", (String)""));
        Assert.assertEquals((Object)"::", (Object)GeneratorUtil.toRelativePackage((String)"acme::store", (String)"acme::store"));
        Assert.assertEquals((Object)"..::store::", (Object)GeneratorUtil.toRelativePackage((String)"acme::floor", (String)"acme::store"));
        Assert.assertEquals((Object)"...::store::", (Object)GeneratorUtil.toRelativePackage((String)"acme::floor::first", (String)"acme::store"));
        Assert.assertEquals((Object)"...::store::", (Object)GeneratorUtil.toRelativePackage((String)"acme::floor::first::second", (String)"acme::store"));
        Assert.assertEquals((Object)"..::floor::first::second::", (Object)GeneratorUtil.toRelativePackage((String)"acme::store", (String)"acme::floor::first::second"));
    }

    @Test
    public void testToCamelCase() {
        Assert.assertEquals((Object)"FruitBasket", (Object)GeneratorUtil.toCamelCase((String)"fruit-basket", (boolean)true));
        Assert.assertEquals((Object)"fruitBasket", (Object)GeneratorUtil.toCamelCase((String)"fruit-basket", (boolean)false));
        Assert.assertEquals((Object)"fruitBasket", (Object)GeneratorUtil.toCamelCase((String)"fruit--basket", (boolean)false));
        Assert.assertEquals((Object)"FruitBasket", (Object)GeneratorUtil.toCamelCase((String)"-fruit-basket", (boolean)false));
        Assert.assertEquals((Object)"OneTwoThreeFourFive", (Object)GeneratorUtil.toCamelCase((String)"one-two-three-four-five", (boolean)true));
        Assert.assertEquals((Object)"OneTwoThreeFourFive", (Object)GeneratorUtil.toCamelCase((String)"oneTwoThree-four-five", (boolean)true));
    }
}

