/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.MetaDataFilters;
import com.metaobjects.io.MetaDataWriter;
import com.metaobjects.loader.MetaDataLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratorIOWriter<T extends GeneratorIOWriter>
extends MetaDataWriter {
    protected static final Logger log = LoggerFactory.getLogger(GeneratorIOWriter.class);
    private MetaDataFilters filters;
    private String name;
    private String filename;

    protected GeneratorIOWriter(MetaDataLoader loader) {
        super(loader);
    }

    public T withName(String name) {
        this.name = name;
        return (T)((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public T withFilters(MetaDataFilters filters) {
        this.filters = filters;
        return (T)((Object)this);
    }

    public MetaDataFilters getFilters() {
        return this.filters;
    }

    public T withFilename(String filename) {
        this.filename = filename;
        return (T)((Object)this);
    }

    public String getFilename() {
        return this.filename;
    }

    public abstract void close() throws GeneratorIOException;

    protected String getToStringOptions() {
        return "loader=" + this.getLoader().getShortName() + (String)(this.name != null ? ",name=" + this.name : "") + (String)(this.filename != null ? ",filename=" + this.filename : "") + (String)(this.filters != null ? ",filters=" + String.valueOf(this.filters) : ",filters=no");
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getClass().getSimpleName() + "{" + this.getToStringOptions() + "}";
    }
}

