/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.JsonStream;
import java.io.IOException;

class StreamImplString {
    private static final byte[] ITOA = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final boolean[] CAN_DIRECT_WRITE = new boolean[128];

    StreamImplString() {
    }

    public static final void writeString(JsonStream stream, String val) throws IOException {
        int bufLengthMinusTwo;
        int i = 0;
        int valLen = val.length();
        int toWriteLen = valLen;
        if (stream.count + toWriteLen > (bufLengthMinusTwo = stream.buf.length - 2)) {
            toWriteLen = bufLengthMinusTwo - stream.count;
        }
        if (toWriteLen < 0) {
            stream.flushBuffer();
            if (stream.count + toWriteLen > bufLengthMinusTwo) {
                toWriteLen = bufLengthMinusTwo - stream.count;
            }
        }
        int n = stream.count;
        stream.buf[n++] = 34;
        while (i < toWriteLen) {
            char c = val.charAt(i);
            try {
                if (!CAN_DIRECT_WRITE[c]) break;
                stream.buf[n++] = (byte)c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            ++i;
        }
        if (i == valLen) {
            stream.buf[n++] = 34;
            stream.count = n;
            return;
        }
        stream.count = n;
        StreamImplString.writeStringSlowPath(stream, val, i, valLen);
        stream.write(34);
    }

    public static final void writeStringWithoutQuote(JsonStream stream, String val) throws IOException {
        char c;
        int bufLen;
        int i = 0;
        int valLen = val.length();
        int toWriteLen = valLen;
        if (stream.count + toWriteLen > (bufLen = stream.buf.length)) {
            toWriteLen = bufLen - stream.count;
        }
        if (toWriteLen < 0) {
            stream.flushBuffer();
            if (stream.count + toWriteLen > bufLen) {
                toWriteLen = bufLen - stream.count;
            }
        }
        int n = stream.count;
        while (i < toWriteLen && (c = val.charAt(i)) > '\u001f' && c != '\"' && c != '\\' && c < '~') {
            stream.buf[n++] = (byte)c;
            ++i;
        }
        if (i == valLen) {
            stream.count = n;
            return;
        }
        stream.count = n;
        StreamImplString.writeStringSlowPath(stream, val, i, valLen);
    }

    private static void writeStringSlowPath(JsonStream stream, String val, int i, int valLen) throws IOException {
        while (i < valLen) {
            char c = val.charAt(i);
            if (c > '}') {
                byte b4 = (byte)(c & 0xF);
                byte b3 = (byte)(c >> 4 & 0xF);
                byte b2 = (byte)(c >> 8 & 0xF);
                byte b1 = (byte)(c >> 12 & 0xF);
                stream.write((byte)92, (byte)117, ITOA[b1], ITOA[b2], ITOA[b3], ITOA[b4]);
            } else {
                switch (c) {
                    case '\"': {
                        stream.write((byte)92, (byte)34);
                        break;
                    }
                    case '\\': {
                        stream.write((byte)92, (byte)92);
                        break;
                    }
                    case '\b': {
                        stream.write((byte)92, (byte)98);
                        break;
                    }
                    case '\f': {
                        stream.write((byte)92, (byte)102);
                        break;
                    }
                    case '\n': {
                        stream.write((byte)92, (byte)110);
                        break;
                    }
                    case '\r': {
                        stream.write((byte)92, (byte)114);
                        break;
                    }
                    case '\t': {
                        stream.write((byte)92, (byte)116);
                        break;
                    }
                    default: {
                        stream.write(c);
                    }
                }
            }
            ++i;
        }
    }

    static {
        for (int i = 0; i < CAN_DIRECT_WRITE.length; ++i) {
            if (i <= 31 || i >= 126 || i == 34 || i == 92) continue;
            StreamImplString.CAN_DIRECT_WRITE[i] = true;
        }
    }
}

