/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.rest;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.networknt.codegen.Generator;
import com.networknt.codegen.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import templates.rest.LICENSE;
import templates.rest.README;
import templates.rest.classpath;
import templates.rest.clientYml;
import templates.rest.dockerfile;
import templates.rest.gitignore;
import templates.rest.handler;
import templates.rest.handlerProvider;
import templates.rest.handlerTest;
import templates.rest.logback;
import templates.rest.middlewareService;
import templates.rest.pojo;
import templates.rest.pom;
import templates.rest.primaryCrt;
import templates.rest.project;
import templates.rest.routingService;
import templates.rest.secondaryCrt;
import templates.rest.secret;
import templates.rest.security;
import templates.rest.server;
import templates.rest.service;
import templates.rest.shutdownHookProvider;
import templates.rest.startupHookProvider;
import templates.rest.testServer;

public class RestGenerator
implements Generator {
    private Map<String, String> typeMapping = new HashMap<String, String>();

    public RestGenerator() {
        this.typeMapping.put("array", "java.util.List");
        this.typeMapping.put("map", "java.util.Map");
        this.typeMapping.put("List", "java.util.List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "byte[]");
    }

    @Override
    public String getFramework() {
        return "light-rest-4j";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        Iterator<Map<String, Any>> any;
        String rootPackage = config.toString("rootPackage");
        String modelPackage = config.toString("modelPackage");
        String handlerPackage = config.toString("handlerPackage");
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean overwriteModel = config.toBoolean("overwriteModel");
        boolean enableHttp = config.toBoolean("enableHttp");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportOracle = config.toBoolean("supportOracle");
        boolean supportMysql = config.toBoolean("supportMysql");
        boolean supportPostgresql = config.toBoolean("supportPostgresql");
        boolean supportH2ForTest = config.toBoolean("supportH2ForTest");
        boolean supportClient = config.toBoolean("supportClient");
        this.transfer(targetPath, "", "pom.xml", pom.template(config));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "", "Dockerfile", dockerfile.template(config, expose));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template(config));
        if (supportOracle) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template("oracle.jdbc.pool.OracleDataSource", "jdbc:oracle:thin:@localhost:1521:XE", "SYSTEM", "oracle"));
        }
        if (supportMysql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template("com.mysql.jdbc.Driver", "jdbc:mysql://mysqldb:3306/oauth2?useSSL=false", "root", "my-secret-pw"));
        }
        if (supportPostgresql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template("org.postgresql.Driver", "jdbc:postgresql://postgresdb:5432/oauth2", "postgres", "my-secret-pw"));
        }
        if (supportH2ForTest) {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "service.yml", service.template("org.h2.jdbcx.JdbcDataSource", "jdbc:h2:~/test", "sa", "sa"));
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", server.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, httpPort, enableHttps, httpsPort, enableRegistry));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secret.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "security.yml", security.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.main.resources.config.oauth".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config.oauth".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.HandlerProvider", routingService.template(rootPackage));
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.handler.MiddlewareHandler", middlewareService.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.StartupHookProvider", startupHookProvider.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.ShutdownHookProvider", shutdownHookProvider.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        this.injectEndpoints(model2);
        List<Map<String, Any>> operationList = this.getOperationList(model2);
        this.transfer(targetPath, ("src.main.java." + rootPackage).replace(".", File.separator), "PathHandlerProvider.java", handlerProvider.template(rootPackage, handlerPackage, operationList));
        if (overwriteModel && ((Any)((Object)(any = ((Any)model2).get((Object)"definitions")))).valueType() != ValueType.INVALID) {
            for (Map.Entry<String, Any> entry : ((Any)((Object)any)).asMap().entrySet()) {
                ArrayList<Map<String, Any>> props = new ArrayList<Map<String, Any>>();
                String key = entry.getKey();
                Map<String, Any> value = entry.getValue().asMap();
                String type = null;
                boolean isEnum = false;
                Map<String, Any> properties = null;
                List<Any> required = null;
                for (Map.Entry<String, Any> entrySchema : value.entrySet()) {
                    if ("type".equals(entrySchema.getKey()) && "enum".equals(type = entrySchema.getValue().toString())) {
                        isEnum = true;
                    }
                    if ("properties".equals(entrySchema.getKey())) {
                        properties = entrySchema.getValue().asMap();
                        for (Map.Entry<String, Any> entryProp : properties.entrySet()) {
                            HashMap<String, Any> propMap = new HashMap<String, Any>();
                            String name = entryProp.getKey();
                            propMap.put("jsonProperty", Any.wrap(name));
                            if (name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            propMap.put("name", Any.wrap(name));
                            propMap.put("getter", Any.wrap("get" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("setter", Any.wrap("set" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("isEnum", Any.wrap(false));
                            boolean isArray = false;
                            for (Map.Entry<String, Any> entryElement : entryProp.getValue().asMap().entrySet()) {
                                String s;
                                Any a;
                                if ("type".equals(entryElement.getKey())) {
                                    String t = this.typeMapping.get(entryElement.getValue().toString());
                                    if ("java.util.List".equals(t)) {
                                        isArray = true;
                                    } else {
                                        propMap.put("type", Any.wrap(t));
                                    }
                                }
                                if ("items".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    if (a.get((Object)"$ref").valueType() != ValueType.INVALID && isArray) {
                                        String s2 = a.get((Object)"$ref").toString();
                                        s2 = s2.substring(s2.lastIndexOf(47) + 1);
                                        propMap.put("type", Any.wrap("java.util.List<" + s2 + ">"));
                                    }
                                    if (a.get((Object)"type").valueType() != ValueType.INVALID && isArray) {
                                        propMap.put("type", Any.wrap("java.util.List<" + this.typeMapping.get(a.get((Object)"type").toString()) + ">"));
                                    }
                                }
                                if ("$ref".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    s = s.substring(s.lastIndexOf(47) + 1);
                                    propMap.put("type", Any.wrap(s));
                                }
                                if ("default".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    propMap.put("default", a);
                                }
                                if ("enum".equals(entryElement.getKey())) {
                                    propMap.put("isEnum", Any.wrap(true));
                                    propMap.put("nameWithEnum", Any.wrap(name.substring(0, 1).toUpperCase() + name.substring(1) + "Enum"));
                                    propMap.put("value", Any.wrap(entryElement.getValue()));
                                }
                                if (!"format".equals(entryElement.getKey())) continue;
                                s = entryElement.getValue().toString();
                                if ("date-time".equals(s)) {
                                    propMap.put("type", Any.wrap("java.time.LocalDateTime"));
                                }
                                if ("date".equals(s)) {
                                    propMap.put("type", Any.wrap("java.time.LocalDate"));
                                }
                                if ("double".equals(s)) {
                                    propMap.put("type", Any.wrap(s));
                                }
                                if (!"float".equals(s)) continue;
                                propMap.put("type", Any.wrap(s));
                            }
                            props.add(propMap);
                        }
                    }
                    if (!"required".equals(entrySchema.getKey())) continue;
                    required = entrySchema.getValue().asList();
                }
                String classVarName = key;
                String modelFileName = key.substring(0, 1).toUpperCase() + key.substring(1);
                this.transfer(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java", pojo.template(modelPackage, modelFileName, classVarName, props));
            }
        }
        if (overwriteHandler) {
            for (Map<String, Any> op : operationList) {
                String className = ((Any)op.get("handlerName")).toString();
                String example = null;
                if (op.get("example") != null) {
                    example = JsonStream.serialize(op.get("example"));
                }
                if ("ServerInfoGetHandler".equals(className) || "HealthGetHandler".equals(className)) continue;
                this.transfer(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java", handler.template(handlerPackage, className, example));
            }
        }
        this.transfer(targetPath, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
        if (overwriteHandlerTest) {
            for (Map<String, Any> op : operationList) {
                this.transfer(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), op.get("handlerName") + "Test.java", handlerTest.template(handlerPackage, op));
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator)), new FileAttribute[0]);
        }
        InputStream is = RestGenerator.class.getResourceAsStream("/binaries/server.keystore");
        Object object = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = RestGenerator.class.getResourceAsStream("/binaries/server.truststore");
        object = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = RestGenerator.class.getResourceAsStream("/binaries/client.keystore");
            object = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = RestGenerator.class.getResourceAsStream("/binaries/client.truststore");
            object = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new FileAttribute[0]);
        }
        is = RestGenerator.class.getResourceAsStream("/binaries/client.keystore");
        object = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = RestGenerator.class.getResourceAsStream("/binaries/client.truststore");
        object = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        JsonStream.serialize(model2, new FileOutputStream(FileSystems.getDefault().getPath(targetPath, "src.main.resources.config".replace(".", File.separator), "swagger.json").toFile()));
    }

    public void injectHealthCheck(Map<String, Any> paths) {
    }

    public void injectEndpoints(Object model2) {
        Any anyModel = (Any)model2;
        Map<String, Any> paths = anyModel.get((Object)"paths").asMap();
        Any securityDefinitions = anyModel.get((Object)"securityDefinitions");
        String authName = null;
        if (securityDefinitions != null) {
            Map<String, Any> sdMap = securityDefinitions.asMap();
            for (String name : sdMap.keySet()) {
                Map<String, Any> def = sdMap.get(name).asMap();
                if (def == null || !"oauth2".equals(def.get("type").toString())) continue;
                authName = name;
                Any scopes = def.get("scopes");
                if (scopes == null) break;
                scopes.asMap().put("server.info.r", Any.wrap("read server info"));
                break;
            }
        }
        HashMap<String, Cloneable> serverInfoMap = new HashMap<String, Cloneable>();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("server.info.r");
        HashMap<String, ArrayList<String>> authMap = new HashMap<String, ArrayList<String>>();
        authMap.put(authName, scopes);
        ArrayList<HashMap<String, ArrayList<String>>> authList = new ArrayList<HashMap<String, ArrayList<String>>>();
        authList.add(authMap);
        serverInfoMap.put("security", authList);
        HashMap<String, String> descMap = new HashMap<String, String>();
        descMap.put("description", "successful operation");
        HashMap<String, HashMap<String, String>> codeMap = new HashMap<String, HashMap<String, String>>();
        codeMap.put("200", descMap);
        serverInfoMap.put("responses", codeMap);
        serverInfoMap.put("parameters", new ArrayList());
        HashMap<String, HashMap<String, Cloneable>> serverInfo = new HashMap<String, HashMap<String, Cloneable>>();
        serverInfo.put("get", serverInfoMap);
        paths.put("/server/info", Any.wrap(serverInfo));
        HashMap<String, Cloneable> healthMap = new HashMap<String, Cloneable>();
        healthMap.put("responses", codeMap);
        healthMap.put("parameters", new ArrayList());
        HashMap<String, HashMap<String, Cloneable>> health = new HashMap<String, HashMap<String, Cloneable>>();
        health.put("get", healthMap);
        paths.put("/health", Any.wrap(health));
    }

    public List<Map<String, Any>> getOperationList(Object model2) {
        ArrayList<Map<String, Any>> result = new ArrayList<Map<String, Any>>();
        Any anyModel = (Any)model2;
        String basePath = anyModel.get((Object)"basePath").toString();
        Map<String, Any> paths = anyModel.get((Object)"paths").asMap();
        for (Map.Entry<String, Any> entryPath : paths.entrySet()) {
            String path = entryPath.getKey();
            Map<String, Any> pathValues = entryPath.getValue().asMap();
            for (Map.Entry<String, Any> entryOps : pathValues.entrySet()) {
                Any examples;
                Any response;
                if (entryOps.getKey().startsWith("x-")) continue;
                HashMap<String, Any> flattened = new HashMap<String, Any>();
                flattened.put("method", Any.wrap(entryOps.getKey().toUpperCase()));
                flattened.put("capMethod", Any.wrap(entryOps.getKey().substring(0, 1).toUpperCase() + entryOps.getKey().substring(1)));
                flattened.put("path", Any.wrap(basePath + path));
                String normalizedPath = path.replace("{", "").replace("}", "");
                flattened.put("normalizedPath", Any.wrap(basePath + normalizedPath));
                flattened.put("handlerName", Any.wrap(Utils.camelize(normalizedPath) + Utils.camelize(entryOps.getKey()) + "Handler"));
                Map<String, Any> values = entryOps.getValue().asMap();
                Any responses = values.get("responses");
                if (responses != null && (response = responses.asMap().get("200")) != null && (examples = response.asMap().get("examples")) != null) {
                    Any jsonRes = examples.asMap().get("application/json");
                    flattened.put("example", jsonRes);
                }
                result.add(flattened);
            }
        }
        return result;
    }
}

