/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static String getUUID() {
        UUID id = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(id.getMostSignificantBits());
        bb.putLong(id.getLeastSignificantBits());
        return Base64.encodeBase64URLSafeString(bb.array());
    }

    public static String quote(String value) {
        if (value == null) {
            return null;
        }
        String result = value;
        if (!result.startsWith("\"")) {
            result = "\"" + result;
        }
        if (!result.endsWith("\"")) {
            result = result + "\"";
        }
        return result;
    }

    public static InetAddress getInetAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (IOException ioe) {
            logger.error("Error in getting InetAddress", ioe);
        }
        return inetAddress;
    }

    public static String getJarVersion() {
        String path = Util.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        logger.debug("path = " + path);
        String ver = null;
        if (path.endsWith(".jar")) {
            int endIndex = path.indexOf(".jar");
            int startIndex = path.lastIndexOf("/");
            String jarName = path.substring(startIndex + 1, endIndex);
            ver = jarName.substring(jarName.lastIndexOf("-") + 1);
        }
        return ver;
    }

    public static String getFrameworkVersion() {
        Class<Util> clazz = Util.class;
        URL location = clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class");
        System.out.println("location = " + location);
        return location.toString();
    }

    public static int parseInteger(String intStr) {
        if (intStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String urlEncode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String urlDecode(String value) {
        if (StringUtils.isBlank(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String substituteVariables(String template, Map<String, String> variables) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!variables.containsKey(matcher.group(1))) continue;
            String replacement = variables.get(matcher.group(1));
            matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

