/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.WiringFactory;
import java.util.ArrayList;
import java.util.List;

public class CombinedWiringFactory
implements WiringFactory {
    private List<WiringFactory> factories;

    public CombinedWiringFactory(List<WiringFactory> factories) {
        Assert.assertNotNull(factories, "You must provide a list of wiring factories");
        this.factories = new ArrayList<WiringFactory>(factories);
    }

    @Override
    public boolean providesTypeResolver(TypeDefinitionRegistry registry, InterfaceTypeDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(registry, definition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean providesTypeResolver(TypeDefinitionRegistry registry, UnionTypeDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(registry, definition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeResolver getTypeResolver(TypeDefinitionRegistry registry, InterfaceTypeDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(registry, definition)) continue;
            return factory.getTypeResolver(registry, definition);
        }
        return null;
    }

    @Override
    public TypeResolver getTypeResolver(TypeDefinitionRegistry registry, UnionTypeDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesTypeResolver(registry, definition)) continue;
            return factory.getTypeResolver(registry, definition);
        }
        return null;
    }

    @Override
    public boolean providesDataFetcher(TypeDefinitionRegistry registry, FieldDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcher(registry, definition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataFetcher getDataFetcher(TypeDefinitionRegistry registry, FieldDefinition definition) {
        for (WiringFactory factory : this.factories) {
            if (!factory.providesDataFetcher(registry, definition)) continue;
            return factory.getDataFetcher(registry, definition);
        }
        return null;
    }
}

