/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.ShouldNotHappenException;
import graphql.execution.TypeFromAST;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import graphql.validation.QueryLanguageVisitor;
import java.util.ArrayList;
import java.util.List;

public class TraversalContext
implements QueryLanguageVisitor {
    GraphQLSchema schema;
    List<GraphQLOutputType> outputTypeStack = new ArrayList<GraphQLOutputType>();
    List<GraphQLCompositeType> parentTypeStack = new ArrayList<GraphQLCompositeType>();
    List<GraphQLInputType> inputTypeStack = new ArrayList<GraphQLInputType>();
    List<GraphQLFieldDefinition> fieldDefStack = new ArrayList<GraphQLFieldDefinition>();
    GraphQLDirective directive;
    GraphQLArgument argument;
    SchemaUtil schemaUtil = new SchemaUtil();

    public TraversalContext(GraphQLSchema graphQLSchema) {
        this.schema = graphQLSchema;
    }

    @Override
    public void enter(Node node, List<Node> path) {
        if (node instanceof OperationDefinition) {
            this.enterImpl((OperationDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.enterImpl((SelectionSet)node);
        } else if (node instanceof Field) {
            this.enterImpl((Field)node);
        } else if (node instanceof Directive) {
            this.enterImpl((Directive)node);
        } else if (node instanceof InlineFragment) {
            this.enterImpl((InlineFragment)node);
        } else if (node instanceof FragmentDefinition) {
            this.enterImpl((FragmentDefinition)node);
        } else if (node instanceof VariableDefinition) {
            this.enterImpl((VariableDefinition)node);
        } else if (node instanceof Argument) {
            this.enterImpl((Argument)node);
        } else if (node instanceof ArrayValue) {
            this.enterImpl((ArrayValue)node);
        } else if (node instanceof ObjectField) {
            this.enterImpl((ObjectField)node);
        }
    }

    private void enterImpl(SelectionSet selectionSet) {
        GraphQLUnmodifiedType rawType = new SchemaUtil().getUnmodifiedType(this.getOutputType());
        GraphQLCompositeType parentType = null;
        if (rawType instanceof GraphQLCompositeType) {
            parentType = (GraphQLCompositeType)((Object)rawType);
        }
        this.addParentType(parentType);
    }

    private void enterImpl(Field field) {
        GraphQLCompositeType parentType = this.getParentType();
        GraphQLFieldDefinition fieldDefinition = null;
        if (parentType != null) {
            fieldDefinition = this.getFieldDef(this.schema, parentType, field);
        }
        this.addFieldDef(fieldDefinition);
        this.addType(fieldDefinition != null ? fieldDefinition.getType() : null);
    }

    private void enterImpl(Directive directive) {
        this.directive = this.schema.getDirective(directive.getName());
    }

    private void enterImpl(OperationDefinition operationDefinition) {
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            this.addType(this.schema.getMutationType());
        } else if (operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            this.addType(this.schema.getQueryType());
        } else if (operationDefinition.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            this.addType(this.schema.getSubscriptionType());
        } else {
            throw new ShouldNotHappenException();
        }
    }

    private void enterImpl(InlineFragment inlineFragment) {
        TypeName typeCondition = inlineFragment.getTypeCondition();
        GraphQLOutputType type = typeCondition != null ? (GraphQLOutputType)this.schema.getType(typeCondition.getName()) : (GraphQLOutputType)((Object)this.getParentType());
        this.addType(type);
    }

    private void enterImpl(FragmentDefinition fragmentDefinition) {
        GraphQLType type = this.schema.getType(fragmentDefinition.getTypeCondition().getName());
        this.addType((GraphQLOutputType)type);
    }

    private void enterImpl(VariableDefinition variableDefinition) {
        GraphQLType type = TypeFromAST.getTypeFromAST(this.schema, variableDefinition.getType());
        this.addInputType((GraphQLInputType)type);
    }

    private void enterImpl(Argument argument) {
        GraphQLArgument argumentType = null;
        if (this.getDirective() != null) {
            argumentType = this.find(this.getDirective().getArguments(), argument.getName());
        } else if (this.getFieldDef() != null) {
            argumentType = this.find(this.getFieldDef().getArguments(), argument.getName());
        }
        this.addInputType(argumentType != null ? argumentType.getType() : null);
        this.argument = argumentType;
    }

    private void enterImpl(ArrayValue arrayValue) {
        GraphQLNullableType nullableType = this.getNullableType(this.getInputType());
        GraphQLInputType inputType = null;
        if (nullableType instanceof GraphQLList) {
            inputType = (GraphQLInputType)((GraphQLList)nullableType).getWrappedType();
        }
        this.addInputType(inputType);
    }

    private void enterImpl(ObjectField objectField) {
        GraphQLInputObjectField inputField;
        GraphQLUnmodifiedType objectType = this.schemaUtil.getUnmodifiedType(this.getInputType());
        GraphQLInputType inputType = null;
        if (objectType instanceof GraphQLInputObjectType && (inputField = ((GraphQLInputObjectType)objectType).getField(objectField.getName())) != null) {
            inputType = inputField.getType();
        }
        this.addInputType(inputType);
    }

    private GraphQLArgument find(List<GraphQLArgument> arguments, String name) {
        for (GraphQLArgument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public void leave(Node node, List<Node> ancestors) {
        if (node instanceof OperationDefinition) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof SelectionSet) {
            this.parentTypeStack.remove(this.parentTypeStack.size() - 1);
        } else if (node instanceof Field) {
            this.fieldDefStack.remove(this.fieldDefStack.size() - 1);
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof Directive) {
            this.directive = null;
        } else if (node instanceof InlineFragment) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof FragmentDefinition) {
            this.outputTypeStack.remove(this.outputTypeStack.size() - 1);
        } else if (node instanceof VariableDefinition) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof Argument) {
            this.argument = null;
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof ArrayValue) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        } else if (node instanceof ObjectField) {
            this.inputTypeStack.remove(this.inputTypeStack.size() - 1);
        }
    }

    private GraphQLNullableType getNullableType(GraphQLType type) {
        return (GraphQLNullableType)(type instanceof GraphQLNonNull ? ((GraphQLNonNull)type).getWrappedType() : type);
    }

    public GraphQLOutputType getOutputType() {
        return this.lastElement(this.outputTypeStack);
    }

    private void addType(GraphQLOutputType type) {
        this.outputTypeStack.add(type);
    }

    private <T> T lastElement(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public GraphQLCompositeType getParentType() {
        return this.lastElement(this.parentTypeStack);
    }

    private void addParentType(GraphQLCompositeType compositeType) {
        this.parentTypeStack.add(compositeType);
    }

    public GraphQLInputType getInputType() {
        return this.lastElement(this.inputTypeStack);
    }

    private void addInputType(GraphQLInputType graphQLInputType) {
        this.inputTypeStack.add(graphQLInputType);
    }

    public GraphQLFieldDefinition getFieldDef() {
        return this.lastElement(this.fieldDefStack);
    }

    private void addFieldDef(GraphQLFieldDefinition fieldDefinition) {
        this.fieldDefStack.add(fieldDefinition);
    }

    public GraphQLDirective getDirective() {
        return this.directive;
    }

    public GraphQLArgument getArgument() {
        return this.argument;
    }

    private GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLType parentType, Field field) {
        if (schema.getQueryType().equals(parentType)) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return Introspection.SchemaMetaFieldDef;
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return Introspection.TypeMetaFieldDef;
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName()) && (parentType instanceof GraphQLObjectType || parentType instanceof GraphQLInterfaceType || parentType instanceof GraphQLUnionType)) {
            return Introspection.TypeNameMetaFieldDef;
        }
        if (parentType instanceof GraphQLFieldsContainer) {
            return ((GraphQLFieldsContainer)parentType).getFieldDefinition(field.getName());
        }
        return null;
    }
}

