/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ExternalRefProcessor;
import io.swagger.parser.processors.PropertyProcessor;
import io.swagger.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class ModelProcessor {
    private final PropertyProcessor propertyProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ModelProcessor(ResolverCache cache, Swagger swagger) {
        this.propertyProcessor = new PropertyProcessor(cache, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processModel(Model model2) {
        if (model2 == null) {
            return;
        }
        if (model2 instanceof RefModel) {
            this.processRefModel((RefModel)model2);
        } else if (model2 instanceof ArrayModel) {
            this.processArrayModel((ArrayModel)model2);
        } else if (model2 instanceof ComposedModel) {
            this.processComposedModel((ComposedModel)model2);
        } else if (model2 instanceof ModelImpl) {
            this.processModelImpl((ModelImpl)model2);
        }
    }

    private void processModelImpl(ModelImpl modelImpl) {
        Map<String, Property> properties = modelImpl.getProperties();
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Property> propertyEntry : properties.entrySet()) {
            Property property = propertyEntry.getValue();
            this.propertyProcessor.processProperty(property);
        }
    }

    private void processComposedModel(ComposedModel composedModel) {
        this.processModel(composedModel.getParent());
        this.processModel(composedModel.getChild());
        List<RefModel> interfaces = composedModel.getInterfaces();
        if (interfaces != null) {
            for (RefModel model2 : interfaces) {
                this.processRefModel(model2);
            }
        }
    }

    private void processArrayModel(ArrayModel arrayModel) {
        Property items = arrayModel.getItems();
        if (items != null) {
            this.propertyProcessor.processProperty(items);
        }
    }

    private void processRefModel(RefModel refModel) {
        String newRef;
        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat()) && (newRef = this.externalRefProcessor.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat())) != null) {
            refModel.set$ref(newRef);
        }
    }
}

