/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.ForIterator;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.runtime.IndexOnlyForIterator;
import com.fizzed.rocker.runtime.PrimitiveCollections;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class Java8Iterator {
    public static <V> void forEach(Collection<V> items, ConsumeCollection<V> consumer) throws RenderingException, IOException {
        for (V item : items) {
            consumer.accept(item);
        }
    }

    public static <V> void forEach(Collection<V> items, ConsumeCollectionWithIterator<V> consumer) throws RenderingException, IOException {
        IndexOnlyForIterator it = new IndexOnlyForIterator(items.size());
        for (V item : items) {
            it.increment();
            consumer.accept(it, item);
        }
    }

    public static <K, V> void forEach(Map<K, V> items, ConsumeMap<K, V> consumer) throws RenderingException, IOException {
        for (Map.Entry<K, V> item : items.entrySet()) {
            consumer.accept(item.getKey(), item.getValue());
        }
    }

    public static <K, V> void forEach(Map<K, V> items, ConsumeMapWithIterator<K, V> consumer) throws RenderingException, IOException {
        IndexOnlyForIterator it = new IndexOnlyForIterator(items.size());
        for (Map.Entry<K, V> item : items.entrySet()) {
            it.increment();
            consumer.accept(it, item.getKey(), item.getValue());
        }
    }

    public static <V> void forEach(boolean[] items, ConsumeCollection<Boolean> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.BooleanCollection(items), consumer);
    }

    public static <V> void forEach(byte[] items, ConsumeCollection<Byte> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ByteCollection(items), consumer);
    }

    public static <V> void forEach(char[] items, ConsumeCollection<Character> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.CharacterCollection(items), consumer);
    }

    public static <V> void forEach(short[] items, ConsumeCollection<Short> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ShortCollection(items), consumer);
    }

    public static <V> void forEach(int[] items, ConsumeCollection<Integer> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.IntegerCollection(items), consumer);
    }

    public static <V> void forEach(long[] items, ConsumeCollection<Long> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.LongCollection(items), consumer);
    }

    public static <V> void forEach(float[] items, ConsumeCollection<Float> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.FloatCollection(items), consumer);
    }

    public static <V> void forEach(double[] items, ConsumeCollection<Double> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.DoubleCollection(items), consumer);
    }

    public static <V> void forEach(Object[] items, ConsumeCollection<Object> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ObjectCollection(items), consumer);
    }

    public static <V> void forEach(boolean[] items, ConsumeCollectionWithIterator<Boolean> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.BooleanCollection(items), consumer);
    }

    public static <V> void forEach(byte[] items, ConsumeCollectionWithIterator<Byte> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ByteCollection(items), consumer);
    }

    public static <V> void forEach(char[] items, ConsumeCollectionWithIterator<Character> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.CharacterCollection(items), consumer);
    }

    public static <V> void forEach(short[] items, ConsumeCollectionWithIterator<Short> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ShortCollection(items), consumer);
    }

    public static <V> void forEach(int[] items, ConsumeCollectionWithIterator<Integer> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.IntegerCollection(items), consumer);
    }

    public static <V> void forEach(long[] items, ConsumeCollectionWithIterator<Long> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.LongCollection(items), consumer);
    }

    public static <V> void forEach(float[] items, ConsumeCollectionWithIterator<Float> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.FloatCollection(items), consumer);
    }

    public static <V> void forEach(double[] items, ConsumeCollectionWithIterator<Double> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.DoubleCollection(items), consumer);
    }

    public static <V> void forEach(Object[] items, ConsumeCollectionWithIterator<Object> consumer) throws RenderingException, IOException {
        Java8Iterator.forEach(new PrimitiveCollections.ObjectCollection(items), consumer);
    }

    public static interface ConsumeMapWithIterator<K, V> {
        public void accept(ForIterator var1, K var2, V var3) throws RenderingException, IOException;
    }

    public static interface ConsumeMap<K, V> {
        public void accept(K var1, V var2) throws RenderingException, IOException;
    }

    public static interface ConsumeCollectionWithIterator<V> {
        public void accept(ForIterator var1, V var2) throws RenderingException, IOException;
    }

    public static interface ConsumeCollection<V> {
        public void accept(V var1) throws RenderingException, IOException;
    }
}

