/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.ReflectionArrayEncoder;
import com.jsoniter.output.ReflectionCollectionEncoder;
import com.jsoniter.output.ReflectionEnumEncoder;
import com.jsoniter.output.ReflectionListEncoder;
import com.jsoniter.output.ReflectionMapEncoder;
import com.jsoniter.output.ReflectionObjectEncoder;
import com.jsoniter.spi.Encoder;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ReflectionEncoderFactory {
    public static Encoder create(Class clazz, Type ... typeArgs) {
        if (clazz.isArray()) {
            return new ReflectionArrayEncoder(clazz, typeArgs);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ReflectionListEncoder(clazz, typeArgs);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new ReflectionCollectionEncoder(clazz, typeArgs);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new ReflectionMapEncoder(clazz, typeArgs);
        }
        if (clazz.isEnum()) {
            return new ReflectionEnumEncoder(clazz);
        }
        return new ReflectionObjectEncoder(clazz);
    }
}

