/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;

public class TypeInfo {
    private final GraphQLType type;
    private final boolean typeIsNonNull;
    private final TypeInfo parentType;

    private TypeInfo(GraphQLType type, TypeInfo parentType, boolean nonNull) {
        this.parentType = parentType;
        this.type = type;
        this.typeIsNonNull = nonNull;
        Assert.assertNotNull(this.type, "you must provide a graphql type");
    }

    public GraphQLType type() {
        return this.type;
    }

    public <T extends GraphQLType> T castType(Class<T> clazz) {
        return (T)((GraphQLType)clazz.cast(this.type));
    }

    public boolean typeIsNonNull() {
        return this.typeIsNonNull;
    }

    public TypeInfo parentTypeInfo() {
        return this.parentType;
    }

    public boolean hasParentType() {
        return this.parentType != null;
    }

    public TypeInfo asType(GraphQLType type) {
        return new TypeInfo(TypeInfo.unwrap(type), this.parentType, this.typeIsNonNull);
    }

    public static Builder newTypeInfo() {
        return new Builder();
    }

    private static GraphQLType unwrap(GraphQLType type) {
        while (type instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getWrappedType();
        }
        return type;
    }

    public String toString() {
        return String.format("TypeInfo { nonnull=%s, type=%s, parentType=%s }", this.typeIsNonNull, this.type, this.parentType);
    }

    static class Builder {
        GraphQLType type;
        TypeInfo parentType;

        Builder() {
        }

        public Builder type(GraphQLType type) {
            this.type = type;
            return this;
        }

        public Builder parentInfo(TypeInfo typeInfo) {
            this.parentType = typeInfo;
            return this;
        }

        public TypeInfo build() {
            if (this.type instanceof GraphQLNonNull) {
                return new TypeInfo(TypeInfo.unwrap(this.type), this.parentType, true);
            }
            return new TypeInfo(this.type, this.parentType, false);
        }
    }
}

