/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public class SimpleListConnection<T>
implements DataFetcher<Connection<T>> {
    private static final String DUMMY_CURSOR_PREFIX = "simple-cursor";
    private final String prefix;
    private final List<T> data;

    public SimpleListConnection(List<T> data, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            throw new IllegalArgumentException("prefix cannot be null or empty");
        }
        this.prefix = prefix;
        this.data = data;
    }

    public SimpleListConnection(List<T> data) {
        this(data, DUMMY_CURSOR_PREFIX);
    }

    private List<Edge<T>> buildEdges() {
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        int ix = 0;
        for (T object : this.data) {
            edges.add(new DefaultEdge<T>(object, new DefaultConnectionCursor(this.createCursor(ix++))));
        }
        return edges;
    }

    @Override
    public Connection<T> get(DataFetchingEnvironment environment) {
        int beforeOffset;
        int end;
        List<Edge<T>> edges = this.buildEdges();
        int afterOffset = this.getOffsetFromCursor((String)environment.getArgument("after"), -1);
        int begin = Math.max(afterOffset, -1) + 1;
        if ((edges = edges.subList(begin, end = Math.min(beforeOffset = this.getOffsetFromCursor((String)environment.getArgument("before"), edges.size()), edges.size()))).size() == 0) {
            return this.emptyConnection();
        }
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        ConnectionCursor firstPresliceCursor = edges.get(0).getCursor();
        ConnectionCursor lastPresliceCursor = edges.get(edges.size() - 1).getCursor();
        if (first != null) {
            edges = edges.subList(0, first <= edges.size() ? first.intValue() : edges.size());
        }
        if (last != null) {
            edges = edges.subList(last > edges.size() ? 0 : edges.size() - last, edges.size());
        }
        if (edges.isEmpty()) {
            return this.emptyConnection();
        }
        Edge<T> firstEdge = edges.get(0);
        Edge<T> lastEdge = edges.get(edges.size() - 1);
        DefaultPageInfo pageInfo = new DefaultPageInfo(firstEdge.getCursor(), lastEdge.getCursor(), !firstEdge.getCursor().equals(firstPresliceCursor), !lastEdge.getCursor().equals(lastPresliceCursor));
        return new DefaultConnection<T>(edges, pageInfo);
    }

    private Connection<T> emptyConnection() {
        DefaultPageInfo pageInfo = new DefaultPageInfo(null, null, false, false);
        return new DefaultConnection(Collections.emptyList(), pageInfo);
    }

    public ConnectionCursor cursorForObjectInConnection(T object) {
        int index = this.data.indexOf(object);
        if (index == -1) {
            return null;
        }
        String cursor = this.createCursor(index);
        return new DefaultConnectionCursor(cursor);
    }

    private int getOffsetFromCursor(String cursor, int defaultValue) {
        if (cursor == null) {
            return defaultValue;
        }
        String string = new String(Base64.getDecoder().decode(cursor), StandardCharsets.UTF_8);
        return Integer.parseInt(string.substring(this.prefix.length()));
    }

    private String createCursor(int offset) {
        byte[] bytes = (this.prefix + Integer.toString(offset)).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(bytes);
    }
}

