/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.execution.ExecutionContext;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.language.Field;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final DataFetchingFieldSelectionSet NOOP = Collections::emptyMap;
    private final FieldCollector fieldCollector;
    private final FieldCollectorParameters parameters;
    private final List<Field> fields;

    public static DataFetchingFieldSelectionSet newCollector(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields) {
        if (fieldType instanceof GraphQLObjectType) {
            return new DataFetchingFieldSelectionSetImpl(executionContext, (GraphQLObjectType)fieldType, fields);
        }
        return NOOP;
    }

    private DataFetchingFieldSelectionSetImpl(ExecutionContext executionContext, GraphQLObjectType fieldType, List<Field> fields) {
        this.fields = fields;
        this.fieldCollector = new FieldCollector();
        this.parameters = FieldCollectorParameters.newParameters(executionContext.getGraphQLSchema(), fieldType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
    }

    @Override
    public Map<String, List<Field>> get() {
        return this.fieldCollector.collectFields(this.parameters, this.fields);
    }
}

