/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.InputObjectTypeDefinition;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInputObjectType
implements GraphQLType,
GraphQLInputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLInputFieldsContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLInputObjectField> fieldMap = new LinkedHashMap<String, GraphQLInputObjectField>();
    private final InputObjectTypeDefinition definition;

    @Internal
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields) {
        this(name, description, fields, null);
    }

    @Internal
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields, InputObjectTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fields, "fields can't be null");
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.buildMap(fields);
    }

    private void buildMap(List<GraphQLInputObjectField> fields) {
        for (GraphQLInputObjectField field : fields) {
            String name = field.getName();
            if (this.fieldMap.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldMap.put(name, field);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<GraphQLInputObjectField> getFields() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    public static Builder newInputObject() {
        return new Builder();
    }

    @Override
    public GraphQLInputObjectField getFieldDefinition(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLInputObjectField> getFieldDefinitions() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public InputObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private InputObjectTypeDefinition definition;
        private List<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(InputObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull(field, "field can't be null");
            this.fields.add(field);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLInputObjectField.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction should not be null");
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder = (GraphQLInputObjectField.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            this.fields.add(builder.build());
            return this;
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            for (GraphQLInputObjectField field : fields) {
                this.field(field);
            }
            return this;
        }

        public GraphQLInputObjectType build() {
            return new GraphQLInputObjectType(this.name, this.description, this.fields, this.definition);
        }
    }
}

