/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.ScalarInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class SchemaPrinter {
    private final Map<Class, TypePrinter<?>> printers = new LinkedHashMap();
    private final Options options;

    public SchemaPrinter() {
        this(Options.defaultOptions());
    }

    public SchemaPrinter(Options options) {
        this.options = options;
        this.printers.put(GraphQLSchema.class, this.schemaPrinter());
        this.printers.put(GraphQLObjectType.class, this.objectPrinter());
        this.printers.put(GraphQLEnumType.class, this.enumPrinter());
        this.printers.put(GraphQLScalarType.class, this.scalarPrinter());
        this.printers.put(GraphQLInterfaceType.class, this.interfacePrinter());
        this.printers.put(GraphQLUnionType.class, this.unionPrinter());
        this.printers.put(GraphQLInputObjectType.class, this.inputObjectPrinter());
    }

    public String print(GraphQLSchema schema) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printer(schema.getClass()).print(out, schema);
        ArrayList<GraphQLType> typesAsList = new ArrayList<GraphQLType>(schema.getAllTypesAsList());
        typesAsList.sort(Comparator.comparing(GraphQLType::getName));
        this.printType(out, typesAsList, GraphQLInputType.class);
        this.printType(out, typesAsList, GraphQLInterfaceType.class);
        this.printType(out, typesAsList, GraphQLUnionType.class);
        this.printType(out, typesAsList, GraphQLObjectType.class);
        this.printType(out, typesAsList, GraphQLEnumType.class);
        this.printType(out, typesAsList, GraphQLScalarType.class);
        return sw.toString();
    }

    private boolean isIntrospectionType(GraphQLType type) {
        return !this.options.isIncludeIntrospectionTypes() && type.getName().startsWith("__");
    }

    private TypePrinter<GraphQLScalarType> scalarPrinter() {
        return (out, type) -> {
            if (!this.options.isIncludeScalars()) {
                return;
            }
            if (!ScalarInfo.isStandardScalar(type)) {
                out.format("scalar %s\n\n", type.getName());
            }
        };
    }

    private TypePrinter<GraphQLEnumType> enumPrinter() {
        return (out, type) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            out.format("enum %s {\n", type.getName());
            for (GraphQLEnumValueDefinition enumValueDefinition : type.getValues()) {
                out.format("   %s\n", enumValueDefinition.getName());
            }
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInterfaceType> interfacePrinter() {
        return (out, type) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            out.format("interface %s {\n", type.getName());
            type.getFieldDefinitions().forEach(fd -> out.format("   %s%s : %s\n", fd.getName(), this.argsString(fd.getArguments()), this.typeString(fd.getType())));
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLUnionType> unionPrinter() {
        return (out, type) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            out.format("union %s = ", type.getName());
            List<GraphQLOutputType> types = type.getTypes();
            for (int i = 0; i < types.size(); ++i) {
                GraphQLOutputType objectType = types.get(i);
                if (i > 0) {
                    out.format(" | ", new Object[0]);
                }
                out.format("%s", objectType.getName());
            }
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLObjectType> objectPrinter() {
        return (out, type) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            out.format("type %s {\n", type.getName());
            type.getFieldDefinitions().forEach(fd -> out.format("   %s%s : %s\n", fd.getName(), this.argsString(fd.getArguments()), this.typeString(fd.getType())));
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInputObjectType> inputObjectPrinter() {
        return (out, type) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            out.format("input %s {\n", type.getName());
            type.getFieldDefinitions().forEach(fd -> out.format("   %s : %s\n", fd.getName(), this.typeString(fd.getType())));
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLSchema> schemaPrinter() {
        return (out, type) -> {
            out.format("schema {\n", new Object[0]);
            GraphQLObjectType queryType = type.getQueryType();
            GraphQLObjectType mutationType = type.getMutationType();
            if (queryType != null) {
                out.format("   query : %s\n", queryType.getName());
            }
            if (mutationType != null) {
                out.format("   mutation : %s\n", mutationType.getName());
            }
            out.format("}\n\n", new Object[0]);
        };
    }

    String typeString(GraphQLType rawType) {
        StringBuilder sb = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        GraphQLType type = rawType;
        while (true) {
            if (type instanceof GraphQLNonNull) {
                type = ((GraphQLNonNull)type).getWrappedType();
                stack.push("!");
                continue;
            }
            if (!(type instanceof GraphQLList)) break;
            type = ((GraphQLList)type).getWrappedType();
            sb.append("[");
            stack.push("]");
        }
        sb.append(type.getName());
        while (!stack.isEmpty()) {
            sb.append((String)stack.pop());
        }
        return sb.toString();
    }

    String argsString(List<GraphQLArgument> arguments) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (GraphQLArgument argument : arguments) {
            if (count == 0) {
                sb.append("(");
            } else {
                sb.append(", ");
            }
            sb.append(argument.getName()).append(" : ").append(this.typeString(argument.getType()));
            Object defaultValue = argument.getDefaultValue();
            if (defaultValue != null) {
                sb.append(" = ");
                if (defaultValue instanceof Number) {
                    sb.append(defaultValue);
                } else {
                    sb.append('\"').append(defaultValue).append('\"');
                }
            }
            ++count;
        }
        if (count > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    private <T> TypePrinter<T> printer(Class<?> clazz) {
        TypePrinter typePrinter = this.printers.computeIfAbsent(clazz, k -> (out, type) -> out.println("Type not implemented : " + type));
        return typePrinter;
    }

    public String print(GraphQLType type) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printType(out, type);
        return sw.toString();
    }

    private void printType(PrintWriter out, List<GraphQLType> typesAsList, Class typeClazz) {
        typesAsList.stream().filter(type -> type.getClass().equals(typeClazz)).forEach(type -> this.printType(out, (GraphQLType)type));
    }

    private void printType(PrintWriter out, GraphQLType type) {
        TypePrinter<GraphQLType> printer = this.printer(type.getClass());
        printer.print(out, type);
    }

    private static interface TypePrinter<T> {
        public void print(PrintWriter var1, T var2);
    }

    public static class Options {
        private final boolean includeIntrospectionTypes;
        private final boolean includeScalars;

        private Options(boolean includeIntrospectionTypes, boolean includeScalars) {
            this.includeIntrospectionTypes = includeIntrospectionTypes;
            this.includeScalars = includeScalars;
        }

        public boolean isIncludeIntrospectionTypes() {
            return this.includeIntrospectionTypes;
        }

        public boolean isIncludeScalars() {
            return this.includeScalars;
        }

        public static Options defaultOptions() {
            return new Options(false, false);
        }

        public Options includeIntrospectionTypes(boolean flag) {
            return new Options(flag, this.includeScalars);
        }

        public Options includeScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, flag);
        }
    }
}

