/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.language.Definition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeExtensionDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.idl.errors.SchemaRedefinitionError;
import graphql.schema.idl.errors.TypeRedefinitionError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class TypeDefinitionRegistry {
    private final Map<String, ScalarTypeDefinition> scalarTypes = new LinkedHashMap<String, ScalarTypeDefinition>();
    private final Map<String, List<TypeExtensionDefinition>> typeExtensions = new LinkedHashMap<String, List<TypeExtensionDefinition>>();
    private final Map<String, TypeDefinition> types = new LinkedHashMap<String, TypeDefinition>();
    private SchemaDefinition schema;

    public TypeDefinitionRegistry merge(TypeDefinitionRegistry typeRegistry) throws SchemaProblem {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        LinkedHashMap tempTypes = new LinkedHashMap();
        typeRegistry.types.values().forEach(newEntry -> this.define(this.types, tempTypes, newEntry).ifPresent(errors::add));
        LinkedHashMap tempScalarTypes = new LinkedHashMap();
        typeRegistry.scalarTypes.values().forEach(newEntry -> this.define(this.scalarTypes, tempScalarTypes, newEntry).ifPresent(errors::add));
        if (typeRegistry.schema != null && this.schema != null) {
            errors.add(new SchemaRedefinitionError(this.schema, typeRegistry.schema));
        }
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        if (this.schema == null) {
            this.schema = typeRegistry.schema;
        }
        this.types.putAll(tempTypes);
        this.scalarTypes.putAll(tempScalarTypes);
        typeRegistry.typeExtensions.entrySet().forEach(newEntry -> {
            List currentList = this.typeExtensions.computeIfAbsent((String)newEntry.getKey(), (Function<String, List<TypeExtensionDefinition>>)((Function<String, List>)k -> new ArrayList()));
            currentList.addAll((Collection)newEntry.getValue());
        });
        return this;
    }

    public Optional<GraphQLError> add(Definition definition) {
        if (definition instanceof TypeExtensionDefinition) {
            TypeExtensionDefinition newEntry = (TypeExtensionDefinition)definition;
            return this.defineExt(this.typeExtensions, newEntry);
        }
        if (definition instanceof ScalarTypeDefinition) {
            ScalarTypeDefinition newEntry = (ScalarTypeDefinition)definition;
            return this.define(this.scalarTypes, this.scalarTypes, newEntry);
        }
        if (definition instanceof TypeDefinition) {
            TypeDefinition newEntry = (TypeDefinition)definition;
            return this.define(this.types, this.types, newEntry);
        }
        if (definition instanceof SchemaDefinition) {
            SchemaDefinition newSchema = (SchemaDefinition)definition;
            if (this.schema != null) {
                return Optional.of(new SchemaRedefinitionError(this.schema, newSchema));
            }
            this.schema = newSchema;
        }
        return Optional.empty();
    }

    private <T extends TypeDefinition> Optional<GraphQLError> define(Map<String, T> source, Map<String, T> target, T newEntry) {
        String name = newEntry.getName();
        TypeDefinition olderEntry = (TypeDefinition)source.get(name);
        if (olderEntry != null) {
            return Optional.of(this.handleReDefinition(olderEntry, newEntry));
        }
        target.put(name, newEntry);
        return Optional.empty();
    }

    private Optional<GraphQLError> defineExt(Map<String, List<TypeExtensionDefinition>> typeExtensions, TypeExtensionDefinition newEntry) {
        List currentList = typeExtensions.computeIfAbsent(newEntry.getName(), k -> new ArrayList());
        currentList.add(newEntry);
        return Optional.empty();
    }

    public Map<String, TypeDefinition> types() {
        return new LinkedHashMap<String, TypeDefinition>(this.types);
    }

    public Map<String, ScalarTypeDefinition> scalars() {
        LinkedHashMap<String, ScalarTypeDefinition> scalars = new LinkedHashMap<String, ScalarTypeDefinition>(ScalarInfo.STANDARD_SCALAR_DEFINITIONS);
        scalars.putAll(this.scalarTypes);
        return scalars;
    }

    public Map<String, List<TypeExtensionDefinition>> typeExtensions() {
        return new LinkedHashMap<String, List<TypeExtensionDefinition>>(this.typeExtensions);
    }

    public Optional<SchemaDefinition> schemaDefinition() {
        return Optional.ofNullable(this.schema);
    }

    private GraphQLError handleReDefinition(TypeDefinition oldEntry, TypeDefinition newEntry) {
        return new TypeRedefinitionError(newEntry, oldEntry);
    }

    public boolean hasType(TypeName typeName) {
        String name = typeName.getName();
        return this.types.containsKey(name) || ScalarInfo.STANDARD_SCALAR_DEFINITIONS.containsKey(name) || this.scalarTypes.containsKey(name) || this.typeExtensions.containsKey(name);
    }

    public Optional<TypeDefinition> getType(Type type) {
        String typeName = TypeInfo.typeInfo(type).getName();
        return this.getType(typeName);
    }

    public Optional<TypeDefinition> getType(String typeName) {
        TypeDefinition typeDefinition = this.types.get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        typeDefinition = this.scalars().get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        return Optional.empty();
    }
}

