/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Stack;

public class TypeInfo {
    private final Type rawType;
    private final TypeName typeName;
    private final Stack<Class<?>> decoration = new Stack();

    public static TypeInfo typeInfo(Type type) {
        return new TypeInfo(type);
    }

    public TypeInfo(Type type) {
        this.rawType = type;
        while (!(type instanceof TypeName)) {
            if (type instanceof NonNullType) {
                this.decoration.push(NonNullType.class);
                type = ((NonNullType)type).getType();
            }
            if (!(type instanceof ListType)) continue;
            this.decoration.push(ListType.class);
            type = ((ListType)type).getType();
        }
        this.typeName = (TypeName)type;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.typeName.getName();
    }

    public <T extends GraphQLType> T decorate(GraphQLType objectType) {
        GraphQLType out = objectType;
        Stack wrappingStack = new Stack();
        wrappingStack.addAll(this.decoration);
        while (!wrappingStack.isEmpty()) {
            Class clazz = (Class)wrappingStack.pop();
            if (clazz.equals(NonNullType.class)) {
                out = new GraphQLNonNull(out);
            }
            if (!clazz.equals(ListType.class)) continue;
            out = new GraphQLList(out);
        }
        return (T)out;
    }

    public String toString() {
        return "TypeInfo{rawType=" + this.rawType + ", typeName=" + this.typeName + ", isNonNull=" + this.decoration + '}';
    }
}

