/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RefUtils {
    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split[0];
        }
        return plausibleName;
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static String readExternalUrlRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url = RefUtils.buildUrl(rootPath, file);
                return RefUtils.readExternalRef(url, RefFormat.URL, auths, null);
            }
            result = RemoteUrl.urlToString(file, auths);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        int i;
        String[] rootPathParts = rootPath.split("/");
        String[] relPathParts = relativePath.split("/");
        if (rootPath == null || relativePath == null) {
            return null;
        }
        int trimRoot = 0;
        int trimRel = 0;
        if (!"".equals(rootPathParts[rootPathParts.length - 1])) {
            trimRoot = 1;
        }
        for (i = 0; i < rootPathParts.length && "".equals(rootPathParts[i]); ++i) {
            ++trimRel;
        }
        for (i = 0; i < relPathParts.length; ++i) {
            if (".".equals(relPathParts[i])) {
                ++trimRel;
                continue;
            }
            if (!"..".equals(relPathParts[i])) continue;
            ++trimRel;
        }
        Object[] outputParts = new String[rootPathParts.length + relPathParts.length - trimRoot - trimRel];
        System.arraycopy(rootPathParts, 0, outputParts, 0, rootPathParts.length - trimRoot);
        System.arraycopy(relPathParts, trimRel, outputParts, rootPathParts.length - trimRoot + trimRel - 1, relPathParts.length - trimRel);
        return StringUtils.join(outputParts, "/");
    }

    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            Path pathToUse;
            result = refFormat == RefFormat.URL ? RemoteUrl.urlToString(file, auths) : (Files.exists(pathToUse = parentDirectory.resolve(file).normalize(), new LinkOption[0]) ? IOUtils.toString((InputStream)new FileInputStream(pathToUse.toFile()), "UTF-8") : ClasspathHelper.loadFileFromClasspath(file));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }
}

