/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.nio.channels.Channel;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.CloseListenerSettable;

public interface TerminateHandler {
    public void forceTermination();

    public void terminated();

    public static class ReadyTask
    implements Runnable {
        private final TerminateHandler handler;

        public ReadyTask(TerminateHandler handler2) {
            this.handler = handler2;
        }

        @Override
        public void run() {
            this.handler.terminated();
        }
    }

    public static class ChannelListenerHandler<C extends Channel & CloseListenerSettable<C>>
    implements TerminateHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

