/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ArrayAny
extends Any {
    private final List<Any> val;

    public ArrayAny(List<Any> val) {
        this.val = val;
    }

    @Override
    public ValueType valueType() {
        return ValueType.ARRAY;
    }

    @Override
    public Object object() {
        return this.val;
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        stream.writeArrayStart();
        Iterator<Any> iter = this.val.iterator();
        if (!iter.hasNext()) {
            stream.writeArrayEnd();
            return;
        }
        iter.next().writeTo(stream);
        while (iter.hasNext()) {
            stream.writeMore();
            iter.next().writeTo(stream);
        }
        stream.writeArrayEnd();
    }

    @Override
    public int size() {
        return this.val.size();
    }

    @Override
    public Iterator<Any> iterator() {
        return this.val.iterator();
    }

    @Override
    public Any get(int index) {
        try {
            return this.val.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return new NotFoundAny(index, this.object());
        }
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            ArrayList<Any> result = new ArrayList<Any>();
            for (Any element : this.val) {
                Any mapped = element.get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.add(mapped);
            }
            return Any.rewrap(result);
        }
        try {
            return this.val.get((Integer)key).get(keys, idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
        catch (ClassCastException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
    }

    @Override
    public String toString() {
        return JsonStream.serialize(this);
    }

    @Override
    public boolean toBoolean() {
        return !this.val.isEmpty();
    }

    @Override
    public int toInt() {
        return this.val.size();
    }

    @Override
    public long toLong() {
        return this.val.size();
    }

    @Override
    public float toFloat() {
        return this.val.size();
    }

    @Override
    public double toDouble() {
        return this.val.size();
    }
}

