/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

class CodegenResult {
    String prelude = null;
    String epilogue = null;
    private StringBuilder lines = new StringBuilder();
    private StringBuilder buffered = new StringBuilder();

    CodegenResult() {
    }

    public static String bufferToWriteOp(String buffered) {
        if (buffered == null) {
            return "";
        }
        if (buffered.length() == 1) {
            return String.format("stream.write((byte)'%s');", CodegenResult.escape(buffered.charAt(0)));
        }
        if (buffered.length() == 2) {
            return String.format("stream.write((byte)'%s', (byte)'%s');", CodegenResult.escape(buffered.charAt(0)), CodegenResult.escape(buffered.charAt(1)));
        }
        if (buffered.length() == 3) {
            return String.format("stream.write((byte)'%s', (byte)'%s', (byte)'%s');", CodegenResult.escape(buffered.charAt(0)), CodegenResult.escape(buffered.charAt(1)), CodegenResult.escape(buffered.charAt(2)));
        }
        if (buffered.length() == 4) {
            return String.format("stream.write((byte)'%s', (byte)'%s', (byte)'%s', (byte)'%s');", CodegenResult.escape(buffered.charAt(0)), CodegenResult.escape(buffered.charAt(1)), CodegenResult.escape(buffered.charAt(2)), CodegenResult.escape(buffered.charAt(3)));
        }
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < buffered.length(); ++i) {
            char c = buffered.charAt(i);
            if (c == '\"') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return String.format("stream.writeRaw(\"%s\", %s);", escaped.toString(), buffered.length());
    }

    private static String escape(char c) {
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        return String.valueOf(c);
    }

    public void append(String str) {
        if (str.contains("stream")) {
            this.appendBuffer();
        }
        this.lines.append(str);
        this.lines.append("\n");
    }

    public void buffer(char c) {
        this.buffered.append(c);
    }

    public void buffer(String s) {
        if (s == null) {
            return;
        }
        this.buffered.append(s);
    }

    public void flushBuffer() {
        if (this.buffered.length() == 0) {
            return;
        }
        if (this.prelude == null) {
            this.prelude = this.buffered.toString();
        } else {
            this.epilogue = this.buffered.toString();
        }
        this.buffered.setLength(0);
    }

    public String toString() {
        return this.lines.toString();
    }

    public void appendBuffer() {
        this.flushBuffer();
        if (this.epilogue != null) {
            this.lines.append(CodegenResult.bufferToWriteOp(this.epilogue));
            this.lines.append("\n");
            this.epilogue = null;
        }
    }

    public String generateWrapperCode(Class clazz) {
        this.flushBuffer();
        StringBuilder lines = new StringBuilder();
        CodegenResult.append(lines, "public void encode(Object obj, com.jsoniter.output.JsonStream stream) throws java.io.IOException {");
        CodegenResult.append(lines, "if (obj == null) { stream.writeNull(); return; }");
        if (this.prelude != null) {
            CodegenResult.append(lines, CodegenResult.bufferToWriteOp(this.prelude));
        }
        CodegenResult.append(lines, String.format("encode_((%s)obj, stream);", clazz.getCanonicalName()));
        if (this.epilogue != null) {
            CodegenResult.append(lines, CodegenResult.bufferToWriteOp(this.epilogue));
        }
        CodegenResult.append(lines, "}");
        return lines.toString();
    }

    private static void append(StringBuilder lines, String line) {
        lines.append(line);
        lines.append('\n');
    }
}

