/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class TypeLiteral<T> {
    public static Map<Type, NativeType> nativeTypes = new HashMap<Type, NativeType>(){
        {
            this.put(Float.TYPE, NativeType.FLOAT);
            this.put(Float.class, NativeType.FLOAT);
            this.put(Double.TYPE, NativeType.DOUBLE);
            this.put(Double.class, NativeType.DOUBLE);
            this.put(Boolean.TYPE, NativeType.BOOLEAN);
            this.put(Boolean.class, NativeType.BOOLEAN);
            this.put(Byte.TYPE, NativeType.BYTE);
            this.put(Byte.class, NativeType.BYTE);
            this.put(Short.TYPE, NativeType.SHORT);
            this.put(Short.class, NativeType.SHORT);
            this.put(Integer.TYPE, NativeType.INT);
            this.put(Integer.class, NativeType.INT);
            this.put(Character.TYPE, NativeType.CHAR);
            this.put(Character.class, NativeType.CHAR);
            this.put(Long.TYPE, NativeType.LONG);
            this.put(Long.class, NativeType.LONG);
            this.put(BigDecimal.class, NativeType.BIG_DECIMAL);
            this.put(BigInteger.class, NativeType.BIG_INTEGER);
            this.put(String.class, NativeType.STRING);
            this.put(Object.class, NativeType.OBJECT);
            this.put(Any.class, NativeType.ANY);
        }
    };
    private static volatile Map<Type, TypeLiteral> typeLiteralCache = new HashMap<Type, TypeLiteral>();
    final Type type;
    final String decoderCacheKey;
    final String encoderCacheKey;
    final NativeType nativeType;

    protected TypeLiteral() {
        this.type = TypeLiteral.getSuperclassTypeParameter(this.getClass());
        this.nativeType = nativeTypes.get(this.type);
        this.decoderCacheKey = TypeLiteral.generateDecoderCacheKey(this.type);
        this.encoderCacheKey = TypeLiteral.generateEncoderCacheKey(this.type);
    }

    public TypeLiteral(Type type, String decoderCacheKey, String encoderCacheKey) {
        this.type = type;
        this.nativeType = nativeTypes.get(this.type);
        this.decoderCacheKey = decoderCacheKey;
        this.encoderCacheKey = encoderCacheKey;
    }

    private static String generateDecoderCacheKey(Type type) {
        return TypeLiteral.generateCacheKey(type, "decoder.");
    }

    private static String generateEncoderCacheKey(Type type) {
        return TypeLiteral.generateCacheKey(type, "encoder.");
    }

    private static String generateCacheKey(Type type, String prefix) {
        StringBuilder decoderClassName = new StringBuilder(prefix);
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAnonymousClass()) {
                throw new JsonException("anonymous class not supported: " + clazz);
            }
            if (clazz.isArray()) {
                decoderClassName.append(clazz.getCanonicalName().replace("[]", "_array"));
            } else {
                decoderClassName.append(clazz.getName().replace("[]", "_array"));
            }
        } else if (type instanceof ParameterizedType) {
            try {
                ParameterizedType pType = (ParameterizedType)type;
                Class clazz = (Class)pType.getRawType();
                decoderClassName.append(clazz.getCanonicalName().replace("[]", "_array"));
                for (int i = 0; i < pType.getActualTypeArguments().length; ++i) {
                    String typeName = TypeLiteral.formatTypeWithoutSpecialCharacter(pType.getActualTypeArguments()[i]);
                    decoderClassName.append('_');
                    decoderClassName.append(typeName);
                }
            }
            catch (Exception e) {
                throw new JsonException("failed to generate cache key for: " + type, e);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)type;
            Type compType = gaType.getGenericComponentType();
            decoderClassName.append(TypeLiteral.formatTypeWithoutSpecialCharacter(compType));
            decoderClassName.append("_array");
        } else {
            throw new UnsupportedOperationException("do not know how to handle: " + type);
        }
        return decoderClassName.toString().replace("$", "_");
    }

    private static String formatTypeWithoutSpecialCharacter(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getCanonicalName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            String typeName = TypeLiteral.formatTypeWithoutSpecialCharacter(pType.getRawType());
            for (Type typeArg : pType.getActualTypeArguments()) {
                typeName = typeName + "_";
                typeName = typeName + TypeLiteral.formatTypeWithoutSpecialCharacter(typeArg);
            }
            return typeName;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)type;
            return TypeLiteral.formatTypeWithoutSpecialCharacter(gaType.getGenericComponentType()) + "_array";
        }
        throw new JsonException("unsupported type: " + type + ", of class " + type.getClass());
    }

    static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new JsonException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }

    public static TypeLiteral create(Type valueType) {
        TypeLiteral typeLiteral = typeLiteralCache.get(valueType);
        if (typeLiteral != null) {
            return typeLiteral;
        }
        return TypeLiteral.createNew(valueType);
    }

    private static synchronized TypeLiteral createNew(Type valueType) {
        TypeLiteral typeLiteral = typeLiteralCache.get(valueType);
        if (typeLiteral != null) {
            return typeLiteral;
        }
        HashMap<Type, TypeLiteral> copy = new HashMap<Type, TypeLiteral>(typeLiteralCache);
        typeLiteral = new TypeLiteral(valueType, TypeLiteral.generateDecoderCacheKey(valueType), TypeLiteral.generateEncoderCacheKey(valueType));
        copy.put(valueType, typeLiteral);
        typeLiteralCache = copy;
        return typeLiteral;
    }

    public Type getType() {
        return this.type;
    }

    public String getDecoderCacheKey() {
        return this.decoderCacheKey;
    }

    public String getEncoderCacheKey() {
        return this.encoderCacheKey;
    }

    public NativeType getNativeType() {
        return this.nativeType;
    }

    public String toString() {
        return "TypeLiteral{type=" + this.type + ", decoderCacheKey='" + this.decoderCacheKey + '\'' + ", encoderCacheKey='" + this.encoderCacheKey + '\'' + '}';
    }

    public static enum NativeType {
        FLOAT,
        DOUBLE,
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        CHAR,
        LONG,
        BIG_DECIMAL,
        BIG_INTEGER,
        STRING,
        OBJECT,
        ANY;

    }
}

