/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen;

import com.networknt.codegen.Generator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class FrameworkRegistry {
    private final Map<String, Generator> frameworks;
    private static final FrameworkRegistry INSTANCE = new FrameworkRegistry();

    private FrameworkRegistry() {
        ServiceLoader<Generator> generators = ServiceLoader.load(Generator.class);
        HashMap<String, Generator> map = new HashMap<String, Generator>();
        for (Generator generator : generators) {
            String framework = generator.getFramework();
            map.put(framework, generator);
        }
        this.frameworks = Collections.unmodifiableMap(map);
    }

    public Set<String> getFrameworks() {
        return this.frameworks.keySet();
    }

    public Generator getGenerator(String framework) {
        return this.frameworks.get(framework);
    }

    public static FrameworkRegistry getInstance() {
        return INSTANCE;
    }
}

