/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.TypeInfo;
import graphql.language.SourceLocation;
import java.util.List;

public class NonNullableFieldWasNullException
extends RuntimeException
implements GraphQLError {
    private final TypeInfo typeInfo;

    public NonNullableFieldWasNullException(TypeInfo typeInfo) {
        super(NonNullableFieldWasNullException.buildMsg(typeInfo));
        this.typeInfo = typeInfo;
    }

    private static String buildMsg(TypeInfo typeInfo) {
        if (typeInfo.hasParentType()) {
            return String.format("Cannot return null for non-nullable type: '%s' within parent '%s'", typeInfo.type().getName(), typeInfo.parentTypeInfo().type().getName());
        }
        return String.format("Cannot return null for non-nullable type: '%s' ", typeInfo.type().getName());
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return null;
    }

    @Override
    public ErrorType getErrorType() {
        return null;
    }
}

