/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.ObjectTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

@PublicApi
public class GraphQLObjectType
implements GraphQLType,
GraphQLOutputType,
GraphQLFieldsContainer,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private List<GraphQLOutputType> interfaces = new ArrayList<GraphQLOutputType>();
    private final ObjectTypeDefinition definition;

    @Internal
    public GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLOutputType> interfaces) {
        this(name, description, fieldDefinitions, interfaces, null);
    }

    @Internal
    public GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLOutputType> interfaces, ObjectTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null");
        Assert.assertNotNull(interfaces, "interfaces can't be null");
        this.name = name;
        this.description = description;
        this.interfaces = interfaces;
        this.definition = definition;
        this.buildDefinitionMap(fieldDefinitions);
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.interfaces = this.interfaces.stream().map(type -> (GraphQLOutputType)new SchemaUtil().resolveTypeReference((GraphQLType)type, typeMap)).collect(Collectors.toList());
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    public List<GraphQLOutputType> getInterfaces() {
        return new ArrayList<GraphQLOutputType>(this.interfaces);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "GraphQLObjectType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName + ", interfaces=" + this.interfaces + '}';
    }

    public static Builder newObject() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLFieldDefinition> fieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        private List<GraphQLOutputType> interfaces = new ArrayList<GraphQLOutputType>();
        private ObjectTypeDefinition definition;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(ObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, "fieldDefinition can't be null");
            this.fieldDefinitions.add(fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction can't be null");
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder.build());
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            this.fieldDefinitions.add(builder.build());
            return this;
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null");
            this.fieldDefinitions.addAll(fieldDefinitions);
            return this;
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, "interfaceType can't be null");
            this.interfaces.add(interfaceType);
            return this;
        }

        public Builder withInterface(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, "reference can't be null");
            this.interfaces.add(reference);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public Builder withInterfaces(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.withInterface(reference);
            }
            return this;
        }

        public GraphQLObjectType build() {
            return new GraphQLObjectType(this.name, this.description, this.fieldDefinitions, this.interfaces, this.definition);
        }
    }
}

