/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.schema.DataFetcher;
import graphql.schema.TypeResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public class TypeRuntimeWiring {
    private final String typeName;
    private final Map<String, DataFetcher> fieldDataFetchers;
    private final TypeResolver typeResolver;

    private TypeRuntimeWiring(String typeName, Map<String, DataFetcher> fieldDataFetchers, TypeResolver typeResolver) {
        this.typeName = typeName;
        this.fieldDataFetchers = fieldDataFetchers;
        this.typeResolver = typeResolver;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Map<String, DataFetcher> getFieldDataFetchers() {
        return this.fieldDataFetchers;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public static Builder newTypeWiring(String typeName) {
        Assert.assertNotNull(typeName, "You must provide a type name");
        return new Builder().typeName(typeName);
    }

    public static TypeRuntimeWiring newTypeWiring(String typeName, UnaryOperator<Builder> builderFunction) {
        return ((Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName))).build();
    }

    public static class Builder {
        private String typeName;
        private final Map<String, DataFetcher> fieldDataFetchers = new LinkedHashMap<String, DataFetcher>();
        private TypeResolver typeResolver;

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder dataFetcher(String fieldName, DataFetcher dataFetcher) {
            Assert.assertNotNull(dataFetcher, "you must provide a data fetcher");
            Assert.assertNotNull(fieldName, "you must tell us what field");
            this.fieldDataFetchers.put(fieldName, dataFetcher);
            return this;
        }

        public Builder dataFetchers(Map<String, DataFetcher> dataFetchersMap) {
            Assert.assertNotNull(dataFetchersMap, "you must provide a data fetchers map");
            this.fieldDataFetchers.putAll(dataFetchersMap);
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            Assert.assertNotNull(typeResolver, "you must provide a type resolver");
            this.typeResolver = typeResolver;
            return this;
        }

        public TypeRuntimeWiring build() {
            Assert.assertNotNull(this.typeName, "you must provide a type name");
            return new TypeRuntimeWiring(this.typeName, this.fieldDataFetchers, this.typeResolver);
        }
    }
}

