/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.core.filter;

import io.swagger.core.filter.AbstractSpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.model.ApiDescription;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SpecFilter {
    public Swagger filter(Swagger swagger, SwaggerSpecFilter filter, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Swagger clone = new Swagger();
        clone.info(swagger.getInfo()).tags((List<Tag>)(swagger.getTags() == null ? null : new ArrayList<Tag>(swagger.getTags()))).host(swagger.getHost()).basePath(swagger.getBasePath()).schemes(swagger.getSchemes()).consumes(swagger.getConsumes()).produces(swagger.getProduces()).externalDocs(swagger.getExternalDocs()).vendorExtensions(swagger.getVendorExtensions());
        HashSet<String> filteredTags = new HashSet<String>();
        HashSet allowedTags = new HashSet();
        for (String resourcePath : swagger.getPaths().keySet()) {
            Path path = swagger.getPaths().get(resourcePath);
            HashMap<String, Operation> ops = new HashMap<String, Operation>();
            ops.put("get", path.getGet());
            ops.put("put", path.getPut());
            ops.put("post", path.getPost());
            ops.put("delete", path.getDelete());
            ops.put("patch", path.getPatch());
            ops.put("options", path.getOptions());
            Path clonedPath = new Path();
            for (String key : ops.keySet()) {
                HashSet<String> tags;
                Operation op = (Operation)ops.get(key);
                if (op == null) continue;
                ApiDescription desc = new ApiDescription(resourcePath, key);
                if (filter.isOperationAllowed(op, desc, params, cookies, headers)) {
                    clonedPath.set(key, this.filterOperation(filter, op, desc, params, cookies, headers));
                    tags = allowedTags;
                } else {
                    tags = filteredTags;
                }
                if (op.getTags() == null) continue;
                tags.addAll(op.getTags());
            }
            if (clonedPath.isEmpty()) continue;
            clone.path(resourcePath, clonedPath);
        }
        List<Tag> tags = clone.getTags();
        filteredTags.removeAll(allowedTags);
        if (tags != null && !filteredTags.isEmpty()) {
            Iterator<Tag> it = tags.iterator();
            while (it.hasNext()) {
                if (!filteredTags.contains(it.next().getName())) continue;
                it.remove();
            }
            if (clone.getTags().isEmpty()) {
                clone.setTags(null);
            }
        }
        Map<String, Model> definitions = this.filterDefinitions(filter, swagger.getDefinitions(), params, cookies, headers);
        clone.setSecurityDefinitions(swagger.getSecurityDefinitions());
        clone.setSecurity(swagger.getSecurity());
        clone.setDefinitions(definitions);
        if (filter instanceof AbstractSpecFilter && ((AbstractSpecFilter)filter).isRemovingUnreferencedDefinitions()) {
            clone = this.removeBrokenReferenceDefinitions(clone);
        }
        return clone;
    }

    private Swagger removeBrokenReferenceDefinitions(Swagger swagger) {
        if (swagger.getDefinitions() == null || swagger.getDefinitions().isEmpty()) {
            return swagger;
        }
        TreeSet<String> referencedDefinitions = new TreeSet<String>();
        if (swagger.getResponses() != null) {
            for (Response response : swagger.getResponses().values()) {
                String propertyRef = this.getPropertyRef(response.getSchema());
                if (propertyRef == null) continue;
                referencedDefinitions.add(propertyRef);
            }
        }
        if (swagger.getParameters() != null) {
            for (Parameter p : swagger.getParameters().values()) {
                BodyParameter bp;
                Set<String> modelRef;
                if (!(p instanceof BodyParameter) || (modelRef = this.getModelRef((bp = (BodyParameter)p).getSchema())) == null) continue;
                referencedDefinitions.addAll(modelRef);
            }
        }
        if (swagger.getPaths() != null) {
            for (Path path : swagger.getPaths().values()) {
                if (path.getParameters() != null) {
                    for (Parameter p : path.getParameters()) {
                        BodyParameter bp;
                        Set<String> modelRef;
                        if (!(p instanceof BodyParameter) || (modelRef = this.getModelRef((bp = (BodyParameter)p).getSchema())) == null) continue;
                        referencedDefinitions.addAll(modelRef);
                    }
                }
                if (path.getOperations() == null) continue;
                for (Operation op : path.getOperations()) {
                    if (op.getResponses() != null) {
                        for (Response response : op.getResponses().values()) {
                            String propertyRef = this.getPropertyRef(response.getSchema());
                            if (propertyRef == null) continue;
                            referencedDefinitions.add(propertyRef);
                        }
                    }
                    if (op.getParameters() == null) continue;
                    for (Parameter p : op.getParameters()) {
                        BodyParameter bp;
                        Set<String> modelRef;
                        if (!(p instanceof BodyParameter) || (modelRef = this.getModelRef((bp = (BodyParameter)p).getSchema())) == null) continue;
                        referencedDefinitions.addAll(modelRef);
                    }
                }
            }
        }
        if (swagger.getDefinitions() != null) {
            TreeSet<String> nestedReferencedDefinitions = new TreeSet<String>();
            for (String ref : referencedDefinitions) {
                this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
            }
            referencedDefinitions.addAll(nestedReferencedDefinitions);
            swagger.getDefinitions().keySet().retainAll(referencedDefinitions);
        }
        return swagger;
    }

    private void locateReferencedDefinitions(Map<String, Property> props, Set<String> nestedReferencedDefinitions, Swagger swagger) {
        if (props == null) {
            return;
        }
        for (String keyProp : props.keySet()) {
            Property p = props.get(keyProp);
            String ref = this.getPropertyRef(p);
            if (ref == null) continue;
            this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
        }
    }

    private void locateReferencedDefinitions(String ref, Set<String> nestedReferencedDefinitions, Swagger swagger) {
        if (!nestedReferencedDefinitions.contains(ref)) {
            nestedReferencedDefinitions.add(ref);
            Model model2 = swagger.getDefinitions().get(ref);
            if (model2 != null) {
                this.locateReferencedDefinitions(model2.getProperties(), nestedReferencedDefinitions, swagger);
            }
        }
    }

    public Map<String, Model> filterDefinitions(SwaggerSpecFilter filter, Map<String, Model> definitions, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        if (definitions == null) {
            return null;
        }
        LinkedHashMap<String, Model> clonedDefinitions = new LinkedHashMap<String, Model>();
        for (String key : definitions.keySet()) {
            Model clonedModel;
            Model definition = definitions.get(key);
            LinkedHashMap<String, Property> clonedProperties = new LinkedHashMap<String, Property>();
            if (definition.getProperties() != null) {
                for (String propName : definition.getProperties().keySet()) {
                    boolean shouldInclude;
                    Property property = definition.getProperties().get(propName);
                    if (property == null || !(shouldInclude = filter.isPropertyAllowed(definition, property, propName, params, cookies, headers))) continue;
                    clonedProperties.put(propName, property);
                }
            }
            if ((clonedModel = (Model)definition.clone()).getProperties() != null) {
                clonedModel.getProperties().clear();
            }
            if (definition.getVendorExtensions() != null && clonedModel.getVendorExtensions() != null) {
                clonedModel.getVendorExtensions().putAll(definition.getVendorExtensions());
            }
            clonedModel.setProperties(clonedProperties);
            clonedDefinitions.put(key, clonedModel);
        }
        return clonedDefinitions;
    }

    public Operation filterOperation(SwaggerSpecFilter filter, Operation op, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation clonedOperation = new Operation().summary(op.getSummary()).description(op.getDescription()).operationId(op.getOperationId()).schemes(op.getSchemes()).consumes(op.getConsumes()).produces(op.getProduces()).tags(op.getTags()).externalDocs(op.getExternalDocs()).vendorExtensions(op.getVendorExtensions()).deprecated(op.isDeprecated());
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        if (op.getParameters() != null) {
            for (Parameter param : op.getParameters()) {
                if (!filter.isParamAllowed(param, op, api, params, cookies, headers)) continue;
                clonedParams.add(param);
            }
        }
        clonedOperation.setParameters(clonedParams);
        clonedOperation.setSecurity(op.getSecurity());
        clonedOperation.setResponses(op.getResponses());
        return clonedOperation;
    }

    private String getPropertyRef(Property property) {
        if (property instanceof ArrayProperty && ((ArrayProperty)property).getItems() != null) {
            return this.getPropertyRef(((ArrayProperty)property).getItems());
        }
        if (property instanceof MapProperty && ((MapProperty)property).getAdditionalProperties() != null) {
            return this.getPropertyRef(((MapProperty)property).getAdditionalProperties());
        }
        if (property instanceof RefProperty) {
            return ((RefProperty)property).getSimpleRef();
        }
        return null;
    }

    private Set<String> getModelRef(Model model2) {
        if (model2 instanceof ArrayModel && ((ArrayModel)model2).getItems() != null) {
            String propertyRef = this.getPropertyRef(((ArrayModel)model2).getItems());
            if (propertyRef != null) {
                return new HashSet<String>(Arrays.asList(propertyRef));
            }
        } else {
            if (model2 instanceof ComposedModel && ((ComposedModel)model2).getAllOf() != null) {
                LinkedHashSet<String> refs = new LinkedHashSet<String>();
                ComposedModel cModel = (ComposedModel)model2;
                for (Model ref : cModel.getAllOf()) {
                    if (!(ref instanceof RefModel)) continue;
                    refs.add(((RefModel)ref).getSimpleRef());
                }
                return refs;
            }
            if (model2 instanceof RefModel) {
                return new HashSet<String>(Arrays.asList(((RefModel)model2).getSimpleRef()));
            }
        }
        return null;
    }
}

