/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import java.util.Locale;
import java.util.Map;

public class NameVirtualHostHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final Map<String, HttpHandler> hosts = new CopyOnWriteMap<String, HttpHandler>();

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String hostHeader = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (hostHeader != null) {
            String host = hostHeader.contains(":") ? hostHeader.substring(0, hostHeader.lastIndexOf(":")) : hostHeader;
            HttpHandler handler2 = this.hosts.get(host);
            if (handler2 != null) {
                handler2.handleRequest(exchange);
                return;
            }
            handler2 = this.hosts.get(host.toLowerCase(Locale.ENGLISH));
            if (handler2 != null) {
                handler2.handleRequest(exchange);
                return;
            }
        }
        this.defaultHandler.handleRequest(exchange);
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public Map<String, HttpHandler> getHosts() {
        return this.hosts;
    }

    public NameVirtualHostHandler setDefaultHandler(HttpHandler defaultHandler) {
        Handlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
        return this;
    }

    public synchronized NameVirtualHostHandler addHost(String host, HttpHandler handler2) {
        Handlers.handlerNotNull(handler2);
        this.hosts.put(host.toLowerCase(Locale.ENGLISH), handler2);
        return this;
    }

    public synchronized NameVirtualHostHandler removeHost(String host) {
        this.hosts.remove(host.toLowerCase(Locale.ENGLISH));
        return this;
    }
}

