/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass2) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass2.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass2) {
        return new ArrayList<E>(Arrays.asList(enumClass2.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass2, String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(enumClass2, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass2, String enumName) {
        if (enumName == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass2, enumName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass2, Iterable<? extends E> values) {
        EnumUtils.checkBitVectorable(enumClass2);
        Validate.notNull(values);
        long total = 0L;
        for (Enum constant : values) {
            Validate.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            total |= 1L << constant.ordinal();
        }
        return total;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass2, Iterable<? extends E> values) {
        EnumUtils.asEnum(enumClass2);
        Validate.notNull(values);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass2);
        for (Enum constant : values) {
            Validate.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            condensed.add(constant);
        }
        long[] result = new long[(((Enum[])enumClass2.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            int n = value.ordinal() / 64;
            result[n] = result[n] | 1L << value.ordinal() % 64;
        }
        ArrayUtils.reverse(result);
        return result;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass2, E ... values) {
        Validate.noNullElements(values);
        return EnumUtils.generateBitVector(enumClass2, Arrays.asList(values));
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass2, E ... values) {
        EnumUtils.asEnum(enumClass2);
        Validate.noNullElements(values);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass2);
        Collections.addAll(condensed, values);
        long[] result = new long[(((Enum[])enumClass2.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            int n = value.ordinal() / 64;
            result[n] = result[n] | 1L << value.ordinal() % 64;
        }
        ArrayUtils.reverse(result);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass2, long value) {
        EnumUtils.checkBitVectorable(enumClass2).getEnumConstants();
        return EnumUtils.processBitVectors(enumClass2, value);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass2, long ... values) {
        EnumSet<Enum> results = EnumSet.noneOf(EnumUtils.asEnum(enumClass2));
        long[] lvalues = ArrayUtils.clone(Validate.notNull(values));
        ArrayUtils.reverse(lvalues);
        for (Enum constant : (Enum[])enumClass2.getEnumConstants()) {
            int block = constant.ordinal() / 64;
            if (block >= lvalues.length || (lvalues[block] & 1L << constant.ordinal() % 64) == 0L) continue;
            results.add(constant);
        }
        return results;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass2) {
        Enum[] constants = (Enum[])EnumUtils.asEnum(enumClass2).getEnumConstants();
        Validate.isTrue(constants.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, constants.length, enumClass2.getSimpleName(), 64);
        return enumClass2;
    }

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass2) {
        Validate.notNull(enumClass2, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Validate.isTrue(enumClass2.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass2);
        return enumClass2;
    }
}

