/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.model.basic.jexl;

import com.nosolojava.fsm.impl.model.basic.jexl.SerializableMapContext;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.runtime.SerializableContextInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;

public class JexlMapFSMContextInstance
implements SerializableContextInstance {
    private static final long serialVersionUID = -8517548919319424511L;
    private transient Logger logger = Logger.getLogger(this.getClass().getName());
    private final String sessionId;
    private final String parentSessionId;
    private final List<String> activeStates;
    private final SerializableMapContext innerContext;
    private transient JexlEngine jexl;

    public JexlMapFSMContextInstance(String sessionId, String parentSessionId, SerializableMapContext innerContext, SortedSet<State> activeStates) {
        this.sessionId = sessionId;
        this.parentSessionId = parentSessionId;
        this.innerContext = innerContext;
        this.activeStates = new ArrayList<String>(activeStates != null ? activeStates.size() : 0);
        for (State activeState : activeStates) {
            this.activeStates.add(activeState.getName());
        }
        this.innerContext.removeEntry("_event");
        this.jexl = new JexlEngine();
    }

    private JexlEngine getEngineInstance() {
        if (this.jexl == null) {
            this.jexl = new JexlEngine();
        }
        return this.jexl;
    }

    public boolean isStateActive(String ... stateNames) {
        boolean result = false;
        for (String stateName : stateNames) {
            if (!this.activeStates.contains(stateName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public List<String> getActiveStates() {
        return this.activeStates;
    }

    public Set<String> dataModelKeySet() {
        return this.innerContext.dataModelKeySet();
    }

    public <T> T getDataByName(String name) {
        Object result = this.innerContext.get(name);
        return (T)result;
    }

    public <T> T getDataByExpression(String expression) {
        Expression e;
        try {
            e = this.getEngineInstance().createExpression(expression);
        }
        catch (NullPointerException ex) {
            this.logger.log(Level.SEVERE, String.format("Error evaluating expresion %s", expression), ex);
            return null;
        }
        Object data = e.evaluate((JexlContext)this.innerContext);
        return (T)data;
    }
}

