/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.model.basic.transition;

import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.model.transition.Transition;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Executable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class BasicTransition
implements Transition {
    private static final long serialVersionUID = 3297614985076145446L;
    protected final String sourceState;
    protected final String targetState;
    private final List<Executable> executables = new ArrayList<Executable>();
    private final String eventName;
    private final String guardCondition;
    private final boolean internal;
    private static final String TRANSITION_EXPR = "Transition [{0}-->{1}]";
    private static final String TRANSITION_EXPR_EXTENDED = "Transition [{0}-->{4} event({1}) cond[{2}]/actions: {3} ]";
    private final MessageFormat transitionMF = new MessageFormat("Transition [{0}-->{1}]");
    private final MessageFormat transitionMFExtended = new MessageFormat("Transition [{0}-->{4} event({1}) cond[{2}]/actions: {3} ]");
    private final String toText;

    public BasicTransition(String sourceState, String targetState) {
        this(sourceState, null, targetState, null, false);
    }

    public BasicTransition(String sourceState, String eventName, String targetState) {
        this(sourceState, eventName, targetState, null, false);
    }

    public BasicTransition(String sourceState, String eventName, String targetState, String guardCondition) {
        this(sourceState, eventName, targetState, guardCondition, false);
    }

    public BasicTransition(String sourceState, String eventName, String targetState, String guardCondition, boolean internal) {
        this.sourceState = sourceState;
        this.targetState = targetState;
        this.eventName = eventName;
        this.guardCondition = guardCondition;
        this.internal = internal;
        this.toText = this.transitionMF.format(new Object[]{this.sourceState, this.targetState});
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean passGuardCondition(Context context) {
        boolean result = false;
        result = this.getGuardCondition() != null && !"".equals(this.getGuardCondition()) ? context.evaluateConditionGuardExpresion(this.getGuardCondition()) : true;
        return result;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public State getTargetState(Context context) {
        return this.targetState != null ? context.getState(this.targetState) : null;
    }

    public State getSourceState(Context context) {
        return context.getState(this.sourceState);
    }

    public List<Executable> getExecutables() {
        return this.executables;
    }

    public void addExecutable(Executable executable) {
        this.executables.add(executable);
    }

    public void addExecutables(List<Executable> executables) {
        if (executables != null) {
            this.executables.addAll(executables);
        }
    }

    public void clearAndSetExecutables(List<Executable> executables) {
        this.executables.clear();
        this.addExecutables(executables);
    }

    public String toString() {
        return this.toText;
    }

    public String toStringVerbose() {
        return this.transitionMFExtended.format(new Object[]{this.sourceState, this.eventName, "" + this.guardCondition, this.executables.size(), this.targetState});
    }

    public String getGuardCondition() {
        return this.guardCondition;
    }

    public static void main(String[] args) {
        String ENTRY_STATE_EXPR = "'in-->({0})'";
        MessageFormat entryMF = new MessageFormat(ENTRY_STATE_EXPR);
        System.out.println(entryMF.format(new Object[]{"hola"}));
    }
}

