/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.invokeHandler;

import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.AbstractBasicInvokeHandler;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.parser.exception.SCXMLParserException;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.StateMachineEngine;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeInfo;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScxmlInvokeHandler
extends AbstractBasicInvokeHandler {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final long serialVersionUID = 8225274975110994110L;
    public static final String NAME = "scxml";
    private StateMachineEngine engine;

    public ScxmlInvokeHandler() {
    }

    public ScxmlInvokeHandler(StateMachineEngine engine) {
        this.engine = engine;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public void invokeServiceInternal(InvokeInfo invokeInfo, Context context) {
        String fsmSessionId = invokeInfo.getInvokeId();
        context.registerInvokeSessionId(fsmSessionId);
        URI fsmModelSource = invokeInfo.getSource();
        Map initValues = null;
        if (invokeInfo.getBody() != null && Map.class.isAssignableFrom(invokeInfo.getBody().getClass())) {
            try {
                initValues = (Map)invokeInfo.getBody();
            }
            catch (ClassCastException e) {
                this.logger.log(Level.FINEST, "Error getting params map from invoke, invokeinfo: {0}", new Object[]{invokeInfo});
            }
        }
        try {
            this.engine.startFSMSession(fsmSessionId, context.getSessionId(), fsmModelSource, initValues);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SCXMLParserException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onEndSession(String invokeId, Context context) {
        context.unRegisterInvokeSessionId(invokeId);
    }

    @Override
    public void sendMessageToService(Message message, Context context) {
        context.getScxmlIOProcessor().sendMessageFromFSM(message);
    }
}

