/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql;

import com.objectsql.IBaseService;
import com.objectsql.IQuery;
import com.objectsql.ObjectSQLManager;
import com.objectsql.SQLServiceImpl;
import com.objectsql.annotation.RdId;
import com.objectsql.exception.ORMException;
import com.objectsql.exception.ORMSQLException;
import com.objectsql.helper.SQLHelper;
import com.objectsql.helper.SQLHelperCreator;
import com.objectsql.listener.IChangeListener;
import com.objectsql.listener.IChangedListener;
import com.objectsql.listener.IDefaultListener;
import com.objectsql.listener.IORMListener;
import com.objectsql.listener.IQueryListener;
import com.objectsql.listener.IServiceChangedListener;
import com.objectsql.query.QueryUtils;
import com.objectsql.support.ChangeHolder;
import com.objectsql.support.Condition;
import com.objectsql.support.Expression;
import com.objectsql.support.LambdaQuery;
import com.objectsql.support.MultiOrder;
import com.objectsql.support.Names;
import com.objectsql.support.ORMOption;
import com.objectsql.support.ORMType;
import com.objectsql.support.Options;
import com.objectsql.support.Pageable;
import com.objectsql.support.PreChangeCache;
import com.objectsql.support.QueryInfo;
import com.objectsql.utils.ORMUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

public abstract class BaseServiceImpl<T>
extends SQLServiceImpl
implements IBaseService<T>,
BeanFactoryAware {
    private List<IORMListener> listeners = new ArrayList<IORMListener>();
    private List<IDefaultListener> defaultListeners = new ArrayList<IDefaultListener>();
    private List<IChangeListener> changeListeners = new ArrayList<IChangeListener>();
    private List<IChangedListener> changedListeners = new ArrayList<IChangedListener>();
    private List<IQueryListener> queryListeners = new ArrayList<IQueryListener>();
    private ListableBeanFactory factory;

    public BaseServiceImpl() {
        this.init();
    }

    private void init() {
        Type[] ts = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.thisClass = (Class)ts[0];
        this.serviceClass = this.getClass();
    }

    public BaseServiceImpl(ObjectSQLManager objectSQLManager) {
        super(objectSQLManager);
        this.init();
    }

    public BaseServiceImpl(DataSource dataSource) {
        super(new ObjectSQLManager(dataSource));
        this.init();
    }

    @Override
    public List<IORMListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(List<IORMListener> listeners) {
        this.listeners.clear();
        if (listeners != null) {
            this.listeners.addAll(listeners);
        }
    }

    @Override
    public List<IDefaultListener> getDefaultListeners() {
        return this.defaultListeners;
    }

    @Override
    public void setDefaultListeners(List<IDefaultListener> defaultListeners) {
        this.defaultListeners.clear();
        if (defaultListeners != null) {
            this.defaultListeners.addAll(defaultListeners);
        }
    }

    @Override
    public List<IChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    @Override
    public void setChangeListeners(List<IChangeListener> changeListeners) {
        this.changeListeners.clear();
        if (changeListeners != null) {
            this.changeListeners.addAll(changeListeners);
        }
    }

    @Override
    public List<IChangedListener> getChangedListeners() {
        return this.changedListeners;
    }

    @Override
    public void setChangedListeners(List<IChangedListener> changedListeners) {
        this.changedListeners.clear();
        if (changedListeners != null) {
            this.changedListeners.addAll(changedListeners);
        }
    }

    @Override
    public List<IQueryListener> getQueryListeners() {
        return this.queryListeners;
    }

    @Override
    public void setQueryListeners(List<IQueryListener> queryListeners) {
        this.queryListeners.clear();
        if (queryListeners != null) {
            this.queryListeners.addAll(queryListeners);
        }
    }

    @Override
    public void copyAllListeners(IBaseService service) {
        if (service != null) {
            service.setChangedListeners(this.getChangedListeners());
            service.setListeners(this.getListeners());
            service.setChangeListeners(this.getChangeListeners());
            service.setQueryListeners(this.getQueryListeners());
            service.setDefaultListeners(this.getDefaultListeners());
        }
    }

    @Override
    public void addDefaultListener(IDefaultListener listener) {
        if (!this.defaultListeners.contains(listener)) {
            this.defaultListeners.add(listener);
        }
    }

    @Override
    public void removeDefaultListener(IDefaultListener listener) {
        if (this.defaultListeners.contains(listener)) {
            this.defaultListeners.remove(listener);
        }
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        if (this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    @Override
    public void addChangedListener(IChangedListener listener) {
        if (!this.changedListeners.contains(listener)) {
            this.changedListeners.add(listener);
        }
    }

    @Override
    public void removeChangedListener(IChangedListener listener) {
        if (this.changedListeners.contains(listener)) {
            this.changedListeners.remove(listener);
        }
    }

    @Override
    public void addORMListener(IORMListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeORMListener(IORMListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void addQueryListener(IQueryListener listener) {
        if (!this.queryListeners.contains(listener)) {
            this.queryListeners.add(listener);
        }
    }

    @Override
    public void removeQueryListener(IQueryListener listener) {
        if (this.queryListeners.contains(listener)) {
            this.queryListeners.remove(listener);
        }
    }

    private <S> void sortAddListeners(List<S> result, Class<S> clazz) {
        Map listenerMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.factory, clazz);
        for (Object listener : listenerMap.values()) {
            if (IBaseService.class.isAssignableFrom(listener.getClass()) || !ORMUtils.isTheSameClass(this.thisClass, listener.getClass())) continue;
            result.add(listener);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.factory = (ListableBeanFactory)beanFactory;
        this.sortAddListeners(this.listeners, IORMListener.class);
        this.sortAddListeners(this.defaultListeners, IDefaultListener.class);
        this.sortAddListeners(this.changeListeners, IChangeListener.class);
        this.sortAddListeners(this.changedListeners, IChangedListener.class);
        this.sortAddListeners(this.queryListeners, IQueryListener.class);
    }

    private void triggerQueryListener(IQuery query) {
        for (IQueryListener listener : this.queryListeners) {
            listener.handle(this.thisClass, query);
        }
    }

    @Override
    public void triggerDefaultListener(ORMType type, T t) {
        for (IDefaultListener listener : this.defaultListeners) {
            try {
                if (type == ORMType.INSERT) {
                    listener.insert(t);
                    continue;
                }
                if (type == ORMType.UPDATE) {
                    listener.update(t);
                    continue;
                }
                if (type == ORMType.DELETE) {
                    listener.delete(t);
                    continue;
                }
                throw new ORMException("Other type, not support.");
            }
            catch (Exception e) {
                throw new ORMException("Trigger default listener error", e);
            }
        }
    }

    @Override
    public void triggerORMListener(ORMType type, T t) {
        this.triggerORMListener(type, t, false, null);
    }

    @Override
    public void triggerORMListener(ORMType type, T t, boolean updateNull, String[] nullColumns) {
        for (IORMListener listener : this.listeners) {
            try {
                if (type == ORMType.INSERT) {
                    listener.insert(t);
                    continue;
                }
                if (type == ORMType.UPDATE) {
                    listener.update(t);
                    listener.update(t, updateNull, nullColumns);
                    continue;
                }
                if (type == ORMType.DELETE) {
                    listener.delete(t);
                    continue;
                }
                throw new ORMException("Other type, not support.");
            }
            catch (Exception e) {
                throw new ORMException("Trigger orm listener error", e);
            }
        }
    }

    @Override
    public void changed(ORMType ormType, ORMOption option) {
        for (IChangedListener listener : this.changedListeners) {
            try {
                if (listener.useDefault()) {
                    listener.changed(option.getOriginal(), option.getCurrent());
                    continue;
                }
                listener.changed(ormType, option, option.getOriginal(), option.getCurrent());
            }
            catch (Exception e) {
                ORMUtils.handleDebugInfo(this.getClass(), "changed", new Object[]{ormType, option, e});
            }
        }
    }

    @Override
    public void triggerChangeListener(ORMType ormType, T original, T t) {
        this.triggerChangeListener(ormType, original, t, false, null);
    }

    @Override
    public void triggerChangeListener(ORMType ormType, T original, T t, boolean updateNull, String[] nullColumns) {
        for (IChangeListener listener : this.changeListeners) {
            try {
                if (listener.useDefault()) {
                    listener.change(original, t);
                    continue;
                }
                listener.change(ormType, new ORMOption(updateNull, nullColumns, original, t), original, t);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw e;
                }
                throw new ORMException(e);
            }
        }
    }

    @Override
    public void triggerChangedListenerImmediately(ORMType ormType, T original, T current) {
        this.changed(ormType, new ORMOption(false, null, original, current));
    }

    @Override
    public void triggerChangedListenerImmediately(ORMType ormType, T original, T current, boolean updateNull, String[] nullColumns) {
        this.changed(ormType, new ORMOption(updateNull, nullColumns, original, current));
    }

    @Override
    public void triggerChangedListenerWhenTransactionFinish(IServiceChangedListener serviceChangedListener, ORMType ormType, T original, T current) {
        this.triggerChangedListenerWhenTransactionFinish(serviceChangedListener, ormType, original, current, false, null);
    }

    @Override
    public void triggerChangedListenerWhenTransactionFinish(IServiceChangedListener serviceChangedListener, ORMType ormType, T original, T current, boolean updateNull, String[] nullColumns) {
        if (!this.changedListeners.isEmpty()) {
            ChangeHolder.cache(new PreChangeCache(serviceChangedListener, ormType, new ORMOption(updateNull, nullColumns, original, current)));
        }
    }

    public void beforeTriggerChangedListener(ORMType ormType, T original, T t, Connection connection) {
        this.beforeTriggerChangedListener(ormType, original, t, false, null, connection);
    }

    public void beforeTriggerChangedListener(ORMType ormType, T original, T t, boolean updateNull, String[] nullColumns, Connection connection) {
        boolean autoCommit = true;
        try {
            autoCommit = connection.getAutoCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (autoCommit) {
            this.changed(ormType, new ORMOption(updateNull, nullColumns, original, t));
            return;
        }
        this.triggerChangedListenerWhenTransactionFinish(this, ormType, original, t, updateNull, nullColumns);
    }

    @Override
    public boolean save(T t) {
        return this.save(t, true);
    }

    @Override
    public boolean saveWithoutListener(T t) {
        return this.save(t, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(T t, boolean enableListener) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            if (enableListener) {
                this.triggerDefaultListener(ORMType.INSERT, t);
            }
            Options options = this.getOptions();
            helper = SQLHelperCreator.insert(t, options);
            ORMUtils.handleDebugInfo(this.serviceClass, "save(object)", helper);
            RdId rdId = null;
            if (helper.getIdValue() == null && helper.getIdField() != null) {
                rdId = helper.getIdField().getAnnotation(RdId.class);
            }
            ps = rdId != null && rdId.autoIncrement() ? conn.prepareStatement(helper.getSql(), 1) : conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(options, ps, helper.getParameters(), conn);
            boolean flag = ps.executeUpdate() > 0;
            try {
                if (rdId != null && rdId.autoIncrement()) {
                    ResultSet seqRs = ps.getGeneratedKeys();
                    if (seqRs.next()) {
                        Object key = seqRs.getObject(1);
                        helper.setId(t, key);
                    }
                    seqRs.close();
                }
            }
            catch (Exception e) {
                throw new ORMSQLException(e, "Save, Get id error").put("object", t).put("enableListener", enableListener);
            }
            if (flag && enableListener) {
                this.triggerORMListener(ORMType.INSERT, t);
                this.triggerChangeListener(ORMType.INSERT, null, t);
                this.beforeTriggerChangedListener(ORMType.INSERT, null, t, conn);
            }
            bl = flag;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "save").put("object", t).put("enableListener", enableListener).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "save").put("object", t).put("enableListener", enableListener).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    @Override
    public boolean update(T t) {
        return this.update(t, false, true, null);
    }

    @Override
    public boolean updateWithoutListener(T t) {
        return this.update(t, false, false, null);
    }

    @Override
    public boolean updateWithoutListener(T t, boolean updateNull) {
        return this.update(t, updateNull, false, null);
    }

    @Override
    public boolean update(T t, boolean updateNull) {
        return this.update(t, updateNull, true, null);
    }

    @Override
    public boolean updateNull(T t, String ... forNullColumns) {
        return this.update(t, false, true, forNullColumns);
    }

    @Override
    public boolean updateNullWithoutListener(T t, String ... forNullColumns) {
        return this.update(t, false, false, forNullColumns);
    }

    @Override
    public <P, R> boolean updateLambdaNull(T t, LambdaQuery<P, R> ... lambdaQueries) {
        return this.update(t, false, true, QueryUtils.getColumns(lambdaQueries));
    }

    @Override
    public <P, R> boolean updateLambdaNullWithoutListener(T t, LambdaQuery<P, R> ... lambdaQueries) {
        return this.update(t, false, false, QueryUtils.getColumns(lambdaQueries));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean update(T t, boolean updateNull, boolean enableListener, String[] nullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            if (enableListener) {
                this.triggerDefaultListener(ORMType.UPDATE, t);
            }
            helper = SQLHelperCreator.update(this.getOptions(), t, null, updateNull, nullColumns);
            T original = null;
            if (!(helper.getPair() == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty())) {
                original = (T)this.get(helper.getPair().getValue());
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "update(object)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener) {
                this.triggerORMListener(ORMType.UPDATE, t, updateNull, nullColumns);
                this.triggerChangeListener(ORMType.UPDATE, original, t, updateNull, nullColumns);
                this.beforeTriggerChangedListener(ORMType.UPDATE, original, t, updateNull, nullColumns, conn);
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "update").put("object", t).put("updateNull", updateNull).put("enableListener", enableListener).put("nullColumns", nullColumns).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "update").put("object", t).put("updateNull", updateNull).put("enableListener", enableListener).put("nullColumns", nullColumns).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    @Override
    public boolean updates(T t, Expression ... expressions) {
        return this.updates(t, expressions, false, true, null);
    }

    @Override
    public boolean updatesWithoutListener(T t, Expression ... expressions) {
        return this.updates(t, expressions, false, false, null);
    }

    @Override
    public boolean updatesNull(T t, Expression ... expressions) {
        return this.updates(t, expressions, true, true, null);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, Expression ... expressions) {
        return this.updates(t, expressions, true, false, null);
    }

    @Override
    public boolean updatesNull(T t, String[] forNullColumns, Expression ... expressions) {
        return this.updates(t, expressions, false, true, forNullColumns);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, String[] forNullColumns, Expression ... expressions) {
        return this.updates(t, expressions, false, false, forNullColumns);
    }

    @Override
    public <P, R> boolean updatesLambdaNull(T t, LambdaQuery<P, R>[] lambdaQueries, Expression ... expressions) {
        return this.updates(t, expressions, false, true, QueryUtils.getColumns(lambdaQueries));
    }

    @Override
    public <P, R> boolean updatesLambdaNullWithoutListener(T t, LambdaQuery<P, R>[] lambdaQueries, Expression ... expressions) {
        return this.updates(t, expressions, false, false, QueryUtils.getColumns(lambdaQueries));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updates(T t, Expression[] expressions, boolean updateNull, boolean enableListener, String[] forNullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.update(this.getOptions(), t, expressions, updateNull, forNullColumns);
            List<T> originals = null;
            if (!(helper.getIdValue() != null || helper.getIdField() == null || expressions == null || expressions.length <= 0 || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                originals = this.list(expressions);
            }
            if (enableListener && originals != null) {
                for (Object row : originals) {
                    this.triggerDefaultListener(ORMType.UPDATE, row);
                }
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "updates(object)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener && originals != null) {
                for (T original : originals) {
                    Object idValue = ORMUtils.getFieldValue(original, helper.getIdField());
                    ORMUtils.setFieldValue(t, helper.getIdField(), idValue);
                    this.triggerORMListener(ORMType.UPDATE, t, updateNull, forNullColumns);
                    this.triggerChangeListener(ORMType.UPDATE, original, t, updateNull, forNullColumns);
                    this.beforeTriggerChangedListener(ORMType.UPDATE, original, t, updateNull, forNullColumns, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "update").put("object", t).put("updateNull", updateNull).put("enableListener", enableListener).put("expressions", expressions).put("nullColumns", forNullColumns).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "update").put("object", t).put("updateNull", updateNull).put("enableListener", enableListener).put("expressions", expressions).put("nullColumns", forNullColumns).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    @Override
    public boolean updates(T t, Condition condition) {
        return this.updates(t, condition, false, true, null);
    }

    @Override
    public boolean updatesWithoutListener(T t, Condition condition) {
        return this.updates(t, condition, false, false, null);
    }

    @Override
    public boolean updatesNull(T t, Condition condition) {
        return this.updates(t, condition, true, true, null);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, Condition condition) {
        return this.updates(t, condition, true, false, null);
    }

    @Override
    public boolean updatesNull(T t, String[] forNullColumns, Condition condition) {
        return this.updates(t, condition, false, true, forNullColumns);
    }

    @Override
    public boolean updatesNullWithoutListener(T t, String[] forNullColumns, Condition condition) {
        return this.updates(t, condition, false, false, forNullColumns);
    }

    @Override
    public <P, R> boolean updatesLambdaNull(T t, LambdaQuery<P, R>[] lambdaQueries, Condition condition) {
        return this.updates(t, condition, false, true, QueryUtils.getColumns(lambdaQueries));
    }

    @Override
    public <P, R> boolean updatesLambdaNullWithoutListener(T t, LambdaQuery<P, R>[] lambdaQueries, Condition condition) {
        return this.updates(t, condition, false, false, QueryUtils.getColumns(lambdaQueries));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updatesWithoutListener(Expression[] values, Expression[] conditions) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.updateExpress(this.thisClass, this.getOptions(), values, conditions);
            ORMUtils.handleDebugInfo(this.serviceClass, "updatesWithoutListener", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            bl = result = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "updatesWithoutListener").put("values", values).put("expression", conditions).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "updatesWithoutListener").put("values", values).put("expression", conditions).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updates(T t, Condition condition, boolean updateNull, boolean enableListener, String[] forNullColumns) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            conn = this.getConnection();
            helper = SQLHelperCreator.updateTerms(this.getOptions(), t, condition, updateNull, forNullColumns);
            List<T> originals = null;
            if (!(helper.getIdValue() != null || helper.getIdField() == null || condition == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                originals = this.list(condition);
            }
            if (enableListener && originals != null) {
                for (Object row : originals) {
                    this.triggerDefaultListener(ORMType.UPDATE, row);
                }
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "updates(object,condition)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener && originals != null) {
                for (T original : originals) {
                    Object idValue = ORMUtils.getFieldValue(original, helper.getIdField());
                    ORMUtils.setFieldValue(t, helper.getIdField(), idValue);
                    this.triggerORMListener(ORMType.UPDATE, t, updateNull, forNullColumns);
                    this.triggerChangeListener(ORMType.UPDATE, original, t, updateNull, forNullColumns);
                    this.beforeTriggerChangedListener(ORMType.UPDATE, original, t, updateNull, forNullColumns, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "updatesWithoutListener").put("object", t).put("condition", condition).put("updateNull", updateNull).put("enableListener", enableListener).put("nullColumns", forNullColumns).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "updatesWithoutListener").put("object", t).put("condition", condition).put("updateNull", updateNull).put("enableListener", enableListener).put("nullColumns", forNullColumns).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    @Override
    public boolean delete(Object t) {
        return this.delete(t, true);
    }

    @Override
    public boolean deleteWithoutListener(Object object) {
        return this.delete(object, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean delete(Object t, boolean enableListener) {
        boolean bl;
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            Object now = null;
            conn = this.getConnection();
            if (this.thisClass.isInstance(t)) {
                helper = SQLHelperCreator.delete(t);
                now = t;
            } else {
                helper = SQLHelperCreator.delete(this.thisClass, t);
                if (!(!enableListener || helper.getPair() == null || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty())) {
                    now = this.get(helper.getPair().getValue());
                }
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "delete(object)", helper);
            if (enableListener) {
                this.triggerDefaultListener(ORMType.DELETE, now);
            }
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && enableListener) {
                this.triggerORMListener(ORMType.DELETE, now);
                this.triggerChangeListener(ORMType.DELETE, now, null);
                this.beforeTriggerChangedListener(ORMType.DELETE, now, null, conn);
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "delete").put("object", t).put("enableListener", enableListener).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "delete").put("object", t).put("enableListener", enableListener).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    @Override
    public boolean deletes(Condition condition) {
        return this.deletes(condition, true);
    }

    @Override
    public boolean deletesWithoutListener(Condition condition) {
        return this.deletes(condition, false);
    }

    @Override
    public boolean deletes(Expression ... expressions) {
        return this.deletes(true, expressions);
    }

    @Override
    public boolean deletesWithoutListener(Expression ... expressions) {
        return this.deletes(false, expressions);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deletes(Condition condition, boolean enableListener) {
        boolean bl;
        if (condition == null) {
            throw new ORMException("TABLE_DELETE_WITHOUT_EXPRESS, DELETE(Conditions) : " + this.serviceClass);
        }
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            List<T> nows = null;
            conn = this.getConnection();
            helper = SQLHelperCreator.deleteBy(this.thisClass, this.getOptions(), condition);
            if (!(!enableListener || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty() || (nows = this.list(condition)) == null)) {
                for (T t : nows) {
                    this.triggerDefaultListener(ORMType.DELETE, t);
                }
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "deletes(condition)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && nows != null) {
                for (T t : nows) {
                    this.triggerORMListener(ORMType.DELETE, t);
                    this.triggerChangeListener(ORMType.DELETE, t, null);
                    this.beforeTriggerChangedListener(ORMType.DELETE, t, null, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "delete").put("condition", condition).put("enableListener", enableListener).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "delete").put("condition", condition).put("enableListener", enableListener).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deletes(boolean enableListener, Expression ... expressions) {
        boolean bl;
        if (expressions == null || expressions.length == 0) {
            throw new ORMException("TABLE_DELETE_WITHOUT_EXPRESS, DELETE(Expressions) : " + this.serviceClass);
        }
        PreparedStatement ps = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            boolean result;
            List<T> nows = null;
            conn = this.getConnection();
            helper = SQLHelperCreator.deleteBy(this.thisClass, this.getOptions(), expressions);
            if (!(!enableListener || this.changeListeners.isEmpty() && this.changedListeners.isEmpty() && this.defaultListeners.isEmpty() || (nows = this.list(expressions)) == null)) {
                for (T t : nows) {
                    this.triggerDefaultListener(ORMType.DELETE, t);
                }
            }
            ORMUtils.handleDebugInfo(this.serviceClass, "deletes(expressions)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            boolean bl2 = result = ps.executeUpdate() > 0;
            if (result && nows != null) {
                for (T t : nows) {
                    this.triggerORMListener(ORMType.DELETE, t);
                    this.triggerChangeListener(ORMType.DELETE, t, null);
                    this.beforeTriggerChangedListener(ORMType.DELETE, t, null, conn);
                }
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "deletes").put("expressions", expressions).put("enableListener", enableListener).put("helper", helper);
                catch (Exception e2) {
                    if (e2 instanceof ORMException) {
                        throw e2;
                    }
                    throw new ORMSQLException(e2, "deletes").put("expressions", expressions).put("enableListener", enableListener).put("helper", helper);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(null, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(null, ps, conn);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, null, null, null, null, null);
            ORMUtils.handleDebugInfo(this.serviceClass, "list", helper);
            ps = conn.prepareStatement(helper.getSql());
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "list").put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "deletes").put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> listNames(String ... names) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, names, null, null, null, null);
            ORMUtils.handleDebugInfo(this.serviceClass, "listNames(names)", helper);
            ps = conn.prepareStatement(helper.getSql());
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "listNames").put("names", names).put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "listNames").put("names", names).put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(int start, int size) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, null, null, null, start, size);
            ORMUtils.handleDebugInfo(this.serviceClass, "list(start,size)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "list").put("start", start).put("size", size).put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "list").put("start", start).put("size", size).put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(Expression ... expressions) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = SQLHelperCreator.query(this.getOptions(), this.thisClass, expressions);
            ORMUtils.handleDebugInfo(this.serviceClass, "list(expressions)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "list").put("expressions", expressions).put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "list").put("expressions", expressions).put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public List<T> list(Condition condition) {
        return this.list(null, condition, null, null);
    }

    @Override
    public List<T> list(Condition condition, MultiOrder multiOrder) {
        return this.list(null, condition, multiOrder, null);
    }

    @Override
    public List<T> list(Condition condition, MultiOrder multiOrder, Integer limit) {
        return this.list(null, condition, multiOrder, limit);
    }

    @Override
    public List<T> list(Names names, Condition condition) {
        return this.list(names, condition, null, null);
    }

    @Override
    public List<T> list(Names names, Condition condition, MultiOrder multiOrder) {
        return this.list(names, condition, multiOrder, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> list(Names names, Condition condition, MultiOrder multiOrder, Integer limit) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList temp = new ArrayList();
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.getOptions().doQuery(this.thisClass, names != null ? names.names() : null, condition, multiOrder, 0, limit);
            ORMUtils.handleDebugInfo(this.serviceClass, "list(names, condition, multiOrder, limit)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object tmp = SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
                temp.add(tmp);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "list").put("names", names).put("condition", condition).put("order", multiOrder).put("limit", limit).put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "list").put("names", names).put("condition", condition).put("order", multiOrder).put("limit", limit).put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(Condition condition) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            boolean bl;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCount(this.getOptions(), this.thisClass, condition);
                ORMUtils.handleDebugInfo(this.serviceClass, "exists(condition)", helper);
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                bl = Integer.parseInt(tmp.toString()) > 0;
            }
            catch (SQLException e) {
                try {
                    throw new ORMSQLException(e, "exists").put("condition", condition).put("helper", helper);
                    catch (Exception e2) {
                        if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "exists").put("condition", condition).put("helper", helper);
                        throw (ORMException)e2;
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return bl;
        }
        this.closeConnection(rs, ps, conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(Expression ... expressions) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            boolean bl;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCountExpress(this.getOptions(), this.thisClass, expressions);
                ORMUtils.handleDebugInfo(this.serviceClass, "exists(expressions)", helper);
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                bl = Integer.parseInt(tmp.toString()) > 0;
            }
            catch (SQLException e) {
                try {
                    throw new ORMSQLException(e, "exists").put("expressions", expressions).put("helper", helper);
                    catch (Exception e2) {
                        if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "exists").put("expressions", expressions).put("helper", helper);
                        throw (ORMException)e2;
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return bl;
        }
        this.closeConnection(rs, ps, conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int count(Expression ... expressions) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            int n;
            ps = null;
            rs = null;
            conn = null;
            SQLHelper helper = null;
            try {
                Object tmp;
                conn = this.getConnection();
                helper = SQLHelperCreator.queryCountExpress(this.getOptions(), this.thisClass, expressions);
                ORMUtils.handleDebugInfo(this.serviceClass, "count(expressions)", helper);
                ps = conn.prepareStatement(helper.getSql());
                SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
                rs = ps.executeQuery();
                if (!rs.next() || (tmp = rs.getObject(1)) == null) break block5;
                n = Integer.parseInt(tmp.toString());
            }
            catch (SQLException e) {
                try {
                    throw new ORMSQLException(e, "count").put("expressions", expressions).put("helper", helper);
                    catch (Exception e2) {
                        if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "count").put("expressions", expressions).put("helper", helper);
                        throw (ORMException)e2;
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(rs, ps, conn);
                    throw throwable;
                }
            }
            this.closeConnection(rs, ps, conn);
            return n;
        }
        this.closeConnection(rs, ps, conn);
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <S> S getQuery(IQuery query) {
        S s = null;
        Connection conn = this.getConnection();
        query.setOptions(this.getOptions());
        this.triggerQueryListener(query);
        if (!query.dataPermission()) {
            this.closeConnection(null, null, conn);
            return null;
        }
        QueryInfo qinfo = this.getOptions().doQuery(query, null);
        ORMUtils.handleDebugInfo(this.serviceClass, "getQuery(query)", qinfo);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(qinfo.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                s = (S)SQLHelperCreator.newClass(qinfo.getClazz(), rs, query.getQueryConvert(), this.getResultSetHandler());
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "getQuery").put("query", query).put("queryInfo", qinfo);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "getQuery").put("query", query).put("queryInfo", qinfo);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return s;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S> S get(Object object) {
        if (object == null) {
            return null;
        }
        if (IQuery.class.isAssignableFrom(object.getClass())) {
            return this.getQuery((IQuery)object);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        S temp = null;
        Connection conn = null;
        SQLHelper helper = null;
        try {
            conn = this.getConnection();
            helper = this.thisClass.isInstance(object) ? SQLHelperCreator.get(object, new String[0]) : SQLHelperCreator.get(this.thisClass, object);
            ORMUtils.handleDebugInfo(this.serviceClass, "get(object)", helper);
            ps = conn.prepareStatement(helper.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, helper.getParameters(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                temp = (S)SQLHelperCreator.newClass(this.thisClass, rs, this.getResultSetHandler());
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "get").put("object", object).put("helper", helper);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "getQuery").put("object", object).put("helper", helper);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public <S> List<S> query(IQuery q) {
        return this.innerQuery(q);
    }

    @Override
    public <S> List<S> query(IQuery q, int size) {
        Pageable page = new Pageable();
        page.setPage(1);
        page.setSize(size);
        q.setPageable(page);
        return this.innerQuery(q);
    }

    @Override
    public <S> List<S> query(IQuery q, int offset, int size) {
        Pageable page = new Pageable();
        page.setSize(size);
        page.setOffset(offset);
        q.setPageable(page);
        return this.innerQuery(q);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <S> List<S> innerQuery(IQuery query) {
        ArrayList temp = new ArrayList();
        Connection conn = this.getConnection();
        query.setOptions(this.getOptions());
        this.triggerQueryListener(query);
        if (!query.dataPermission()) {
            this.closeConnection(null, null, conn);
            return temp;
        }
        QueryInfo qinfo = query.doQuery();
        ORMUtils.handleDebugInfo(this.serviceClass, "innerQuery(query)", qinfo);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(qinfo.getSql());
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object t = SQLHelperCreator.newClass(qinfo.getClazz(), rs, query.getQueryConvert(), this.getResultSetHandler());
                temp.add(t);
            }
        }
        catch (SQLException e) {
            try {
                throw new ORMSQLException(e, "innerQuery").put("query", query).put("queryInfo", qinfo);
                catch (Exception e2) {
                    if (!(e2 instanceof ORMException)) throw new ORMSQLException(e2, "innerQuery").put("query", query).put("queryInfo", qinfo);
                    throw (ORMException)e2;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(rs, ps, conn);
                throw throwable;
            }
        }
        this.closeConnection(rs, ps, conn);
        return temp;
    }

    @Override
    public int queryCount(IQuery q) {
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        QueryInfo qinfo = null;
        try {
            conn = this.getConnection();
            q.setOptions(this.getOptions());
            this.triggerQueryListener(q);
            if (!q.dataPermission()) {
                this.closeConnection(null, null, conn);
                int n = count;
                return n;
            }
            qinfo = q.doQueryCount();
            ORMUtils.handleDebugInfo(this.serviceClass, "queryCount(query)", qinfo);
            String query = qinfo.getSql();
            ps = conn.prepareStatement(query);
            SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            this.closeConnection(rs, ps, conn);
        }
        catch (SQLException e) {
            throw new ORMSQLException(e, "queryCount").put("query", q).put("queryInfo", qinfo);
        }
        catch (Exception e) {
            if (e instanceof ORMException) {
                throw (ORMException)e;
            }
            throw new ORMSQLException(e, "queryCount").put("query", q).put("queryInfo", qinfo);
        }
        finally {
            this.closeConnection(rs, ps, conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S> Pageable<S> queryPage(IQuery query, Pageable page) {
        int total;
        ArrayList temp;
        block20: {
            if (page == null) {
                page = new Pageable();
            }
            query.setPageable(page);
            temp = new ArrayList();
            Connection conn = this.getConnection();
            query.setOptions(this.getOptions());
            this.triggerQueryListener(query);
            if (!query.dataPermission()) {
                page.setRows(temp);
                page.setTotal(temp.size());
                this.closeConnection(null, null, conn);
                return page;
            }
            QueryInfo qinfo = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            total = 0;
            try {
                try {
                    qinfo = query.doQueryCount();
                    ORMUtils.handleDebugInfo(this.serviceClass, "queryPage(query, page)", qinfo);
                    String countSQL = qinfo.getSql();
                    ps = conn.prepareStatement(countSQL);
                    SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        total = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new ORMSQLException(e, "queryPage").put("type", "count").put("query", query).put("page", page).put("queryInfo", qinfo);
                        catch (Exception e2) {
                            if (e2 instanceof ORMException) {
                                throw (ORMException)e2;
                            }
                            throw new ORMSQLException(e2, "queryPage").put("type", "count").put("query", query).put("page", page).put("queryInfo", qinfo);
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeConnection(rs, ps, null);
                        throw throwable;
                    }
                }
                this.closeConnection(rs, ps, null);
                if (total <= 0) break block20;
                qinfo = query.doQuery();
                ORMUtils.handleDebugInfo(this.serviceClass, "queryPage(query, page)", qinfo);
                try {
                    ps = conn.prepareStatement(qinfo.getSql());
                    SQLHelperCreator.setParameter(this.getOptions(), ps, qinfo.getValues(), conn);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        Object t = SQLHelperCreator.newClass(qinfo.getClazz(), rs, query.getQueryConvert(), this.getResultSetHandler());
                        temp.add(t);
                    }
                }
                catch (SQLException e) {
                    throw new ORMSQLException(e, "queryPage").put("type", "data").put("query", query).put("page", page).put("queryInfo", qinfo);
                }
                catch (Exception e) {
                    if (e instanceof ORMException) {
                        throw (ORMException)e;
                    }
                    throw new ORMSQLException(e, "queryPage").put("type", "data").put("query", query).put("page", page).put("queryInfo", qinfo);
                }
                finally {
                    this.closeConnection(rs, ps, null);
                }
            }
            finally {
                this.closeConnection(null, null, conn);
            }
        }
        page.setRows(temp);
        page.setTotal(total);
        return page;
    }

    @Override
    public String tableName() throws ORMException {
        return super.getTableName(this.thisClass);
    }

    @Override
    public void createOrUpdate() throws ORMException {
        super.createOrUpdate(this.thisClass);
    }
}

