/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.ICartridge;
import com.openshift.client.IDomain;
import com.openshift.client.IEmbeddableCartridge;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.Cartridge;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.EmbeddableCartridge;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.UserResource;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class APIResource
extends AbstractOpenShiftResource
implements IOpenShiftConnection {
    private static final String SYSPROPERTY_PROXY_PORT = "proxyPort";
    private static final String SYSPROPERTY_PROXY_HOST = "proxyHost";
    private static final String SYSPROPERTY_PROXY_SET = "proxySet";
    private final String login;
    private final String password;
    private List<IDomain> domains;
    private UserResource user;
    private boolean doSSLChecks = false;
    private final List<ICartridge> standaloneCartridgeNames = new ArrayList<ICartridge>();
    private final List<IEmbeddableCartridge> embeddedCartridgeNames = new ArrayList<IEmbeddableCartridge>();
    private final ExecutorService executorService;

    protected APIResource(String login, String password, IRestService service, Map<String, Link> links) {
        super(service, links, null);
        this.login = login;
        this.password = password;
        this.executorService = Executors.newFixedThreadPool(10);
    }

    protected final String getLogin() {
        return this.login;
    }

    protected final String getPassword() {
        return this.password;
    }

    @Override
    public void setEnableSSLCertChecks(boolean doSSLChecks) {
        this.doSSLChecks = doSSLChecks;
    }

    @Override
    public void setProxySet(boolean proxySet) {
        if (proxySet) {
            System.setProperty(SYSPROPERTY_PROXY_SET, "true");
        } else {
            System.setProperty(SYSPROPERTY_PROXY_SET, "false");
        }
    }

    @Override
    public void setProxyHost(String proxyHost) {
        System.setProperty(SYSPROPERTY_PROXY_HOST, proxyHost);
    }

    @Override
    public void setProxyPort(String proxyPort) {
        Assert.notNull(proxyPort);
        System.setProperty(SYSPROPERTY_PROXY_PORT, proxyPort);
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        if (this.user == null) {
            this.user = new UserResource(this, new GetUserRequest().execute(), this.password);
        }
        return this.user;
    }

    @Override
    public List<IDomain> getDomains() throws OpenShiftException {
        if (this.domains == null) {
            this.domains = this.loadDomains();
        }
        return CollectionUtils.toUnmodifiableCopy(this.domains);
    }

    private List<IDomain> loadDomains() throws OpenShiftException {
        ArrayList<IDomain> domains = new ArrayList<IDomain>();
        for (DomainResourceDTO domainDTO : new ListDomainsRequest().execute()) {
            domains.add(new DomainResource(domainDTO, this));
        }
        return domains;
    }

    public IDomain getDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        for (IDomain domain : this.getDomains()) {
            if (!domain.getId().equals(id)) continue;
            return domain;
        }
        return null;
    }

    public IDomain getDefaultDomain() {
        List<IDomain> domains = this.getDomains();
        if (domains.size() > 0) {
            return domains.get(0);
        }
        return null;
    }

    public IDomain createDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        if (this.hasDomain(id)) {
            throw new OpenShiftException("Domain {0} already exists", id);
        }
        DomainResourceDTO domainDTO = new AddDomainRequest().execute(id);
        DomainResource domain = new DomainResource(domainDTO, this);
        this.domains.add(domain);
        return domain;
    }

    @Override
    public List<ICartridge> getStandaloneCartridges() throws OpenShiftException {
        if (this.standaloneCartridgeNames.isEmpty()) {
            this.retrieveCartridges();
        }
        return this.standaloneCartridgeNames;
    }

    @Override
    public List<IEmbeddableCartridge> getEmbeddableCartridges() throws OpenShiftException {
        if (this.embeddedCartridgeNames.isEmpty()) {
            this.retrieveCartridges();
        }
        return CollectionUtils.toUnmodifiableCopy(this.embeddedCartridgeNames);
    }

    private void retrieveCartridges() throws OpenShiftException {
        List<CartridgeResourceDTO> cartridgeDTOs = new GetCartridgesRequest().execute();
        for (CartridgeResourceDTO cartridgeDTO : cartridgeDTOs) {
            switch (cartridgeDTO.getType()) {
                case STANDALONE: {
                    this.standaloneCartridgeNames.add(new Cartridge(cartridgeDTO.getName()));
                    break;
                }
                case EMBEDDED: {
                    this.embeddedCartridgeNames.add(new EmbeddableCartridge(cartridgeDTO.getName()));
                    break;
                }
            }
        }
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.domains = null;
    }

    protected void removeDomain(IDomain domain) {
        this.domains.remove(domain);
    }

    protected boolean hasDomain(String name) throws OpenShiftException {
        return this.getDomain(name) != null;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void disconnect() {
        this.standaloneCartridgeNames.clear();
        this.embeddedCartridgeNames.clear();
        this.domains = null;
        this.executorService.shutdownNow();
    }

    private class GetCartridgesRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetCartridgesRequest() throws OpenShiftException {
            super(APIResource.this, "LIST_CARTRIDGES");
        }

        public List<CartridgeResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new ServiceParameter[0]);
        }
    }

    private class GetUserRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetUserRequest() throws OpenShiftException {
            super(APIResource.this, "GET_USER");
        }

        public UserResourceDTO execute() throws OpenShiftException {
            return (UserResourceDTO)super.execute(new ServiceParameter[0]);
        }
    }

    private class ListDomainsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public ListDomainsRequest() throws OpenShiftException {
            super(APIResource.this, "LIST_DOMAINS");
        }

        public List<DomainResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new ServiceParameter[0]);
        }
    }

    private class AddDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public AddDomainRequest() throws OpenShiftException {
            super(APIResource.this, "ADD_DOMAIN");
        }

        public DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)this.execute(new ServiceParameter("id", namespace));
        }
    }
}

