/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.GearResource;
import com.openshift.internal.client.response.GearDTO;
import com.openshift.internal.client.response.GearGroupDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearGroupResource
extends AbstractOpenShiftResource
implements IGearGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(GearGroupResource.class);
    private String name;
    private String gearProfile;
    private List<IGear> gears = new ArrayList<IGear>();

    protected GearGroupResource(GearGroupDTO dto, ApplicationResource app) {
        this(dto.getName(), dto.getGearProfile(), dto.getGears(), app);
    }

    protected GearGroupResource(String name, String gearProfile, List<GearDTO> dtos, ApplicationResource app) {
        super(app.getService());
        this.name = name;
        this.gearProfile = gearProfile;
        for (GearDTO gear : dtos) {
            this.gears.add(new GearResource(gear, this));
        }
    }

    @Override
    public List<IGear> getGears() {
        return this.gears;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGearProfile() {
        return this.gearProfile;
    }
}

