/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.IOpenShiftConfiguration;
import com.openshift.client.configuration.OpenShiftConfiguration;
import com.openshift.internal.client.AbstractOpenShiftConnectionFactory;
import com.openshift.internal.client.RestService;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClientBuilder;
import com.openshift.internal.client.httpclient.request.JsonMediaType;
import com.openshift.internal.client.response.OpenShiftJsonDTOFactory;
import com.openshift.internal.client.utils.Assert;
import java.io.IOException;

public class OpenShiftConnectionFactory
extends AbstractOpenShiftConnectionFactory {
    private IOpenShiftConfiguration configuration = null;

    public IOpenShiftConnection getConnection(String clientId, String password) throws OpenShiftException {
        try {
            this.configuration = new OpenShiftConfiguration();
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        return this.getConnection(clientId, this.configuration.getRhlogin(), password, this.configuration.getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password) throws OpenShiftException {
        try {
            this.configuration = new OpenShiftConfiguration();
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        return this.getConnection(clientId, username, password, this.configuration.getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String serverUrl) throws OpenShiftException {
        return this.getConnection(clientId, username, password, serverUrl, (IHttpClient.ISSLCertificateCallback)null);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String serverUrl, IHttpClient.ISSLCertificateCallback sslCallback) throws OpenShiftException {
        return this.getConnection(clientId, username, password, null, null, serverUrl, sslCallback);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String authKey, String authIV, String serverUrl) throws OpenShiftException {
        return this.getConnection(clientId, username, password, null, null, serverUrl, null);
    }

    public IOpenShiftConnection getConnection(String clientId, String username, String password, String authKey, String authIV, String serverUrl, IHttpClient.ISSLCertificateCallback sslCertificateCallback) throws OpenShiftException {
        if (this.configuration == null) {
            try {
                this.configuration = new OpenShiftConfiguration();
            }
            catch (IOException e) {
                throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
            }
        }
        Assert.notNull(clientId);
        Assert.notNull(username);
        Assert.notNull(password);
        Assert.notNull(serverUrl);
        try {
            IHttpClient httpClient = new UrlConnectionHttpClientBuilder().setCredentials(username, password, authKey, authIV).setSSLCertificateCallback(sslCertificateCallback).setConfigTimeout(this.configuration.getTimeout()).client();
            return this.getConnection(clientId, username, password, serverUrl, httpClient);
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to establish connection for user ''{0}}''", username);
        }
    }

    protected IOpenShiftConnection getConnection(String clientId, String username, String password, String serverUrl, IHttpClient httpClient) throws OpenShiftException, IOException {
        Assert.notNull(clientId);
        Assert.notNull(serverUrl);
        Assert.notNull(httpClient);
        RestService service = new RestService(serverUrl, clientId, new JsonMediaType(), "application/json", new OpenShiftJsonDTOFactory(), httpClient);
        return this.getConnection(service, username, password);
    }
}

