/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.cartridge.query;

import com.openshift.client.IApplication;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.query.LatestVersionQuery;
import com.openshift.internal.client.utils.Assert;
import java.util.List;

public class LatestEmbeddableCartridge {
    private LatestVersionQuery query;

    public LatestEmbeddableCartridge(String name) {
        this.query = new LatestVersionQuery(name);
    }

    public boolean matches(ICartridge cartridge) {
        return this.query.matches(cartridge);
    }

    public <C extends IEmbeddableCartridge> C get(List<C> cartridges) {
        Assert.notNull(cartridges);
        return (C)((IEmbeddableCartridge)this.query.get(cartridges));
    }

    public IEmbeddableCartridge get(IOpenShiftConnection connection) {
        Assert.notNull(connection);
        return this.get(connection.getEmbeddableCartridges());
    }

    public IEmbeddableCartridge get(IApplication application) {
        Assert.notNull(application);
        return this.get(application.getDomain().getUser().getConnection());
    }

    public IEmbeddableCartridge get(IUser user) {
        Assert.notNull(user);
        return this.get(user.getConnection());
    }
}

