/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.CartridgeType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceProperties;
import java.net.URL;

public class EmbeddedCartridgeResource
extends AbstractOpenShiftResource
implements IEmbeddedCartridge {
    private static final String LINK_DELETE_CARTRIDGE = "DELETE";
    private final String name;
    private String displayName;
    private String description;
    private final CartridgeType type;
    private URL url;
    private final ApplicationResource application;
    private CartridgeResourceProperties properties;

    protected EmbeddedCartridgeResource(CartridgeResourceDTO dto, ApplicationResource application) {
        super(application.getService(), dto.getLinks(), dto.getMessages());
        this.name = dto.getName();
        this.displayName = dto.getDisplayName();
        this.description = dto.getDescription();
        this.type = CartridgeType.EMBEDDED;
        this.url = dto.getUrl();
        this.properties = dto.getProperties();
        this.application = application;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CartridgeType getType() {
        return this.type;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isDownloadable() {
        return this.url != null;
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    protected void update(CartridgeResourceDTO dto) {
        this.description = dto.getDescription();
        this.displayName = dto.getDisplayName();
        this.url = dto.getUrl();
        this.properties = dto.getProperties();
        this.setLinks(dto.getLinks());
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.application.refreshEmbeddedCartridges();
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteCartridgeRequest().execute(new Parameter[0]);
        this.application.removeEmbeddedCartridge(this);
    }

    @Override
    public CartridgeResourceProperties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IEmbeddableCartridge.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IEmbeddableCartridge other = (IEmbeddableCartridge)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        return "EmbeddedCartridgeResource [name=" + this.name + "url=" + this.url + ", displayName=" + this.displayName + ", description=" + this.description + ", type=" + (Object)((Object)this.type) + ", application=" + this.application.getName() + "]";
    }

    private class DeleteCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private DeleteCartridgeRequest() {
            super(EmbeddedCartridgeResource.this, EmbeddedCartridgeResource.LINK_DELETE_CARTRIDGE);
        }
    }
}

