/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.InvalidCredentialsOpenShiftException;
import com.openshift.client.Messages;
import com.openshift.client.NotFoundOpenShiftException;
import com.openshift.client.OpenShiftEndpointException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftTimeoutException;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.RestServiceProperties;
import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.NotFoundException;
import com.openshift.internal.client.httpclient.UnauthorizedException;
import com.openshift.internal.client.httpclient.request.IMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.response.IRestResponseFactory;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.RestResponse;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.StringUtils;
import com.openshift.internal.client.utils.UrlUtils;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService
implements IRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestService.class);
    private String server;
    private IMediaType defaultRequestMediaType;
    private IHttpClient client;
    private IRestResponseFactory factory;

    public RestService(String server, String clientId, IMediaType defaultRequestMediaType, String acceptedMediaType, IRestResponseFactory factory, IHttpClient client) {
        this(server, clientId, defaultRequestMediaType, acceptedMediaType, factory, client, new RestServiceProperties());
    }

    protected RestService(String server, String clientId, IMediaType defaultRequestMediaType, String acceptedMediaType, IRestResponseFactory factory, IHttpClient client, RestServiceProperties properties) {
        this(server, clientId, null, defaultRequestMediaType, acceptedMediaType, factory, client, properties);
    }

    protected RestService(String server, String clientId, String protocolVersion, IMediaType defaultRequestMediaType, String acceptedMediaType, IRestResponseFactory factory, IHttpClient client, RestServiceProperties properties) {
        Assert.notEmpty(server);
        Assert.notNull(defaultRequestMediaType);
        Assert.notEmpty(acceptedMediaType);
        Assert.notNull(factory);
        Assert.notNull(properties);
        Assert.notNull(client);
        this.server = UrlUtils.ensureStartsWithHttps(server);
        this.defaultRequestMediaType = defaultRequestMediaType;
        this.factory = factory;
        this.client = client;
        this.setupClient(properties.getUseragent(clientId), protocolVersion, acceptedMediaType, client);
    }

    private void setupClient(String userAgent, String protocolVersion, String acceptedMediaType, IHttpClient client) {
        if (StringUtils.isEmpty(protocolVersion)) {
            protocolVersion = "1.2";
        }
        client.setAcceptedMediaType(acceptedMediaType);
        client.setAcceptVersion(protocolVersion);
        client.setUserAgent(userAgent);
    }

    @Override
    public RestResponse request(Link link, int timeout, List<Parameter> urlPathParameters, List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
        return this.request(link, timeout, this.defaultRequestMediaType, this.factory, urlPathParameters, urlParameters, parameters);
    }

    @Override
    public RestResponse request(Link link, int timeout, IRestResponseFactory responseFactory, List<Parameter> urlPathParameters, List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
        return this.request(link, timeout, this.defaultRequestMediaType, responseFactory, urlPathParameters, urlParameters, parameters);
    }

    @Override
    public RestResponse request(Link link, int timeout, IMediaType requestMediaType, IRestResponseFactory responseFactory, List<Parameter> urlPathParameter, List<Parameter> urlParameters, Parameter ... parameters) throws OpenShiftException {
        String url = link.getHref(this.server, "/broker/rest/", urlPathParameter, urlParameters);
        try {
            String response = this.request(new URL(url), link.getHttpMethod(), requestMediaType, timeout, parameters);
            return responseFactory.get(response);
        }
        catch (EncodingException e) {
            throw new OpenShiftException(e, e.getMessage(), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException(e, e.getMessage(), new Object[0]);
        }
        catch (UnauthorizedException e) {
            throw new InvalidCredentialsOpenShiftException(url, e, this.getRestResponse(e));
        }
        catch (NotFoundException e) {
            throw new NotFoundOpenShiftException(url, e, this.getRestResponse(e));
        }
        catch (HttpClientException e) {
            RestResponse restResponse = this.getRestResponse(e);
            String message = this.getMessage(restResponse, e);
            throw new OpenShiftEndpointException(url.toString(), e, restResponse, "Could not request {0}: {1}", url, message);
        }
        catch (SocketTimeoutException e) {
            throw new OpenShiftTimeoutException(url, (Throwable)e, "Could not request url {0}, connection timed out", url);
        }
    }

    private RestResponse getRestResponse(HttpClientException clientException) {
        try {
            return this.factory.get(clientException.getMessage());
        }
        catch (OpenShiftException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String getMessage(RestResponse restResponse, HttpClientException e) {
        if (restResponse == null) {
            return e.getMessage();
        }
        Messages messages = restResponse.getMessages();
        if (messages == null) {
            return "";
        }
        return messages.toString();
    }

    private String request(URL url, HttpMethod httpMethod, IMediaType mediaType, int timeout, Parameter ... parameters) throws HttpClientException, SocketTimeoutException, OpenShiftException, EncodingException {
        LOGGER.info("Requesting {} with protocol {} on {}", new Object[]{httpMethod.name(), "1.2", url});
        switch (httpMethod) {
            case GET: {
                return this.client.get(url, timeout);
            }
            case HEAD: {
                return this.client.head(url, timeout);
            }
            case POST: {
                return this.client.post(url, mediaType, timeout, parameters);
            }
            case PUT: {
                return this.client.put(url, mediaType, timeout, parameters);
            }
            case DELETE: {
                return this.client.delete(url, mediaType, timeout, parameters);
            }
            case PATCH: {
                return this.client.patch(url, mediaType, timeout, parameters);
            }
        }
        throw new OpenShiftException("Unexpected HTTP method {0}", httpMethod.toString());
    }

    @Override
    public String getServiceUrl() {
        return this.server + "/broker/rest/";
    }

    @Override
    public String getPlatformUrl() {
        return this.server;
    }
}

