/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.ApplicationScale;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.response.AbstractJsonDTOFactory;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceProperties;
import com.openshift.internal.client.response.CartridgeResourceProperty;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.EnumDataType;
import com.openshift.internal.client.response.EnvironmentVariableResourceDTO;
import com.openshift.internal.client.response.GearGroupResourceDTO;
import com.openshift.internal.client.response.GearResourceDTO;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftJsonDTOFactory
extends AbstractJsonDTOFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(OpenShiftJsonDTOFactory.class);

    @Override
    protected Object createData(EnumDataType dataType, Messages messages, ModelNode dataNode) {
        switch (dataType) {
            case user: {
                return this.createUser(dataNode);
            }
            case keys: {
                return this.createKeys(dataNode);
            }
            case key: {
                return this.createKey(dataNode, messages);
            }
            case links: {
                return this.createLinks(dataNode);
            }
            case domains: {
                return this.createDomains(dataNode);
            }
            case domain: {
                return this.createDomain(dataNode, messages);
            }
            case applications: {
                return this.createApplications(dataNode);
            }
            case application: {
                return this.createApplication(dataNode, messages);
            }
            case gear_groups: {
                return this.createGearGroups(dataNode);
            }
            case cartridges: {
                return this.createCartridges(dataNode);
            }
            case cartridge: {
                return this.createCartridge(dataNode, messages);
            }
            case environment_variables: {
                return this.createEnvironmentVariables(dataNode);
            }
            case environment_variable: {
                return this.createEnvironmentVariable(dataNode, messages);
            }
        }
        return null;
    }

    private UserResourceDTO createUser(ModelNode userNode) throws OpenShiftException {
        if (!userNode.isDefined()) {
            return null;
        }
        String rhlogin = this.getAsString(userNode, "login");
        int maxGears = this.getAsInteger(userNode, "max_gears");
        int consumedGears = this.getAsInteger(userNode, "consumed_gears");
        Map<String, Link> links = this.createLinks(userNode.get("links"));
        return new UserResourceDTO(rhlogin, maxGears, consumedGears, links);
    }

    private List<KeyResourceDTO> createKeys(ModelNode dataNode) throws OpenShiftException {
        ArrayList<KeyResourceDTO> keys = new ArrayList<KeyResourceDTO>();
        for (ModelNode keyNode : dataNode.asList()) {
            KeyResourceDTO dto;
            if (keyNode.getType() != ModelType.OBJECT || (dto = this.createKey(keyNode, null)) == null) continue;
            keys.add(dto);
        }
        return keys;
    }

    private KeyResourceDTO createKey(ModelNode keyNode, Messages messages) throws OpenShiftException {
        if (!keyNode.isDefined()) {
            return null;
        }
        String name = this.getAsString(keyNode, "name");
        String type = this.getAsString(keyNode, "type");
        String content = this.getAsString(keyNode, "content");
        Map<String, Link> links = this.createLinks(keyNode.get("links"));
        return new KeyResourceDTO(name, type, content, links, messages);
    }

    private Map<String, Link> createLinks(ModelNode linksNode) throws OpenShiftException {
        if (linksNode.has("data")) {
            return this.createLinks(linksNode.get("data"));
        }
        HashMap<String, Link> links = new HashMap<String, Link>();
        if (linksNode.isDefined()) {
            for (ModelNode linkNode : linksNode.asList()) {
                String linkName = linkNode.asProperty().getName();
                ModelNode valueNode = linkNode.asProperty().getValue();
                if (!valueNode.isDefined()) continue;
                links.put(linkName, this.createLink(valueNode));
            }
        }
        return links;
    }

    private Link createLink(ModelNode valueNode) {
        String rel = this.getAsString(valueNode, "rel");
        String href = valueNode.get("href").asString();
        String method = valueNode.get("method").asString();
        List<LinkParameter> requiredParams = this.createLinkParameters(valueNode.get("required_params"));
        List<LinkParameter> optionalParams = this.createLinkParameters(valueNode.get("optional_params"));
        return new Link(rel, href, method, requiredParams, optionalParams);
    }

    private List<DomainResourceDTO> createDomains(ModelNode dataNode) throws OpenShiftException {
        ArrayList<DomainResourceDTO> domainDtos = new ArrayList<DomainResourceDTO>();
        for (ModelNode domainNode : dataNode.asList()) {
            DomainResourceDTO dto;
            if (domainNode.getType() != ModelType.OBJECT || (dto = this.createDomain(domainNode, null)) == null) continue;
            domainDtos.add(dto);
        }
        return domainDtos;
    }

    private DomainResourceDTO createDomain(ModelNode domainNode, Messages messages) throws OpenShiftException {
        if (!domainNode.isDefined() || domainNode.getType() != ModelType.OBJECT) {
            return null;
        }
        String namespace = this.getAsString(domainNode, "id");
        String suffix = this.getAsString(domainNode, "suffix");
        Map<String, Link> links = this.createLinks(domainNode.get("links"));
        return new DomainResourceDTO(namespace, suffix, links, messages);
    }

    private List<ApplicationResourceDTO> createApplications(ModelNode dataNode) throws OpenShiftException {
        ArrayList<ApplicationResourceDTO> applicationDTOs = new ArrayList<ApplicationResourceDTO>();
        for (ModelNode applicationNode : dataNode.asList()) {
            ApplicationResourceDTO dto = this.createApplication(applicationNode, null);
            if (dto == null) continue;
            applicationDTOs.add(dto);
        }
        return applicationDTOs;
    }

    private ApplicationResourceDTO createApplication(ModelNode appNode, Messages messages) throws OpenShiftException {
        if (!appNode.isDefined()) {
            return null;
        }
        String framework = this.getAsString(appNode, "framework");
        String creationTime = this.getAsString(appNode, "creation_time");
        String name = this.getAsString(appNode, "name");
        String uuid = this.getAsString(appNode, "uuid");
        ApplicationScale scalable = ApplicationScale.safeValueOf(this.getAsString(appNode, "scalable"));
        GearProfile gearProfile = this.createGearProfile(appNode);
        String applicationUrl = this.getAsString(appNode, "app_url");
        String sshUrl = this.getAsString(appNode, "ssh_url");
        String gitUrl = this.getAsString(appNode, "git_url");
        String initialGitUrl = this.getAsString(appNode, "initial_git_url");
        String deploymentType = this.getAsString(appNode, "deployment_type");
        String domainId = this.getAsString(appNode, "domain_id");
        Map<String, Link> links = this.createLinks(appNode.get("links"));
        List<String> aliases = this.createAliases(appNode.get("aliases"));
        Map<String, CartridgeResourceDTO> cartridges = this.createCartridges(appNode.get("cartridges"));
        return new ApplicationResourceDTO(framework, domainId, creationTime, name, gearProfile, scalable, uuid, applicationUrl, sshUrl, gitUrl, initialGitUrl, deploymentType, aliases, cartridges, links, messages);
    }

    private GearProfile createGearProfile(ModelNode appNode) {
        String gearProfileName = this.getAsString(appNode, "gear_profile");
        if (gearProfileName == null) {
            return null;
        }
        return new GearProfile(gearProfileName);
    }

    private Collection<GearGroupResourceDTO> createGearGroups(ModelNode dataNode) {
        ArrayList<GearGroupResourceDTO> gearGroupDTOs = new ArrayList<GearGroupResourceDTO>();
        for (ModelNode gearGroupNode : dataNode.asList()) {
            GearGroupResourceDTO dto = this.createGearGroupResourceDTO(gearGroupNode);
            if (dto == null) continue;
            gearGroupDTOs.add(dto);
        }
        return gearGroupDTOs;
    }

    private GearGroupResourceDTO createGearGroupResourceDTO(ModelNode gearGroupNode) {
        if (!gearGroupNode.isDefined()) {
            return null;
        }
        String uuid = this.getAsString(gearGroupNode, "uuid");
        String name = this.getAsString(gearGroupNode, "name");
        Collection<GearResourceDTO> gears = this.createGears(gearGroupNode.get("gears"));
        Map<String, CartridgeResourceDTO> cartridges = this.createCartridges(gearGroupNode.get("cartridges"));
        return new GearGroupResourceDTO(uuid, name, gears, cartridges);
    }

    private Collection<GearResourceDTO> createGears(ModelNode gearsNode) {
        ArrayList<GearResourceDTO> gears = new ArrayList<GearResourceDTO>();
        for (ModelNode gearNode : gearsNode.asList()) {
            gears.add(new GearResourceDTO(this.getAsString(gearNode, "id"), this.getAsString(gearNode, "state"), this.getAsString(gearNode, "ssh_url")));
        }
        return gears;
    }

    private Map<String, CartridgeResourceDTO> createCartridges(ModelNode cartridgesNode) throws OpenShiftException {
        LinkedHashMap<String, CartridgeResourceDTO> cartridgesByName = new LinkedHashMap<String, CartridgeResourceDTO>();
        if (cartridgesNode.isDefined() && cartridgesNode.getType() == ModelType.LIST) {
            for (ModelNode cartridgeNode : cartridgesNode.asList()) {
                CartridgeResourceDTO cartridgeResourceDTO = this.createCartridge(cartridgeNode, null);
                cartridgesByName.put(cartridgeResourceDTO.getName(), cartridgeResourceDTO);
            }
        }
        return cartridgesByName;
    }

    private CartridgeResourceDTO createCartridge(ModelNode cartridgeNode, Messages messages) throws OpenShiftException {
        String name = this.getAsString(cartridgeNode, "name");
        String displayName = this.getAsString(cartridgeNode, "display_name");
        String description = this.getAsString(cartridgeNode, "description");
        String type = this.getAsString(cartridgeNode, "type");
        URL url = this.createUrl(this.getAsString(cartridgeNode, "url"), name);
        CartridgeResourceProperties properties = this.createProperties(cartridgeNode.get("properties"));
        Map<String, Link> links = this.createLinks(cartridgeNode.get("links"));
        return new CartridgeResourceDTO(name, displayName, description, type, url, properties, links, messages);
    }

    private URL createUrl(String url, String name) {
        try {
            if (url == null) {
                return null;
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            this.LOGGER.warn("Url {} in server response for cartridge {} is not a valid URL.", (Object)url, (Object)name);
            return null;
        }
    }

    private List<String> createAliases(ModelNode aliasNodesList) {
        ArrayList<String> aliases = new ArrayList<String>();
        switch (aliasNodesList.getType()) {
            case OBJECT: 
            case LIST: {
                for (ModelNode aliasNode : aliasNodesList.asList()) {
                    aliases.add(aliasNode.asString());
                }
                break;
            }
            default: {
                aliases.add(aliasNodesList.asString());
            }
        }
        return aliases;
    }

    private List<LinkParameter> createLinkParameters(ModelNode linkParamNodes) throws OpenShiftRequestException {
        ArrayList<LinkParameter> linkParams = new ArrayList<LinkParameter>();
        if (linkParamNodes.isDefined()) {
            for (ModelNode linkParamNode : linkParamNodes.asList()) {
                linkParams.add(this.createLinkParameter(linkParamNode));
            }
        }
        return linkParams;
    }

    private LinkParameter createLinkParameter(ModelNode linkParamNode) throws OpenShiftRequestException {
        String description = linkParamNode.get("description").asString();
        String type = linkParamNode.get("type").asString();
        String defaultValue = linkParamNode.get("default_value").asString();
        String name = linkParamNode.get("name").asString();
        return new LinkParameter(name, type, defaultValue, description, this.createValidOptions(linkParamNode));
    }

    private List<String> createValidOptions(ModelNode linkParamNode) {
        ArrayList<String> validOptions = new ArrayList<String>();
        ModelNode validOptionsNode = linkParamNode.get("valid_options");
        if (validOptionsNode.isDefined()) {
            switch (validOptionsNode.getType()) {
                case STRING: {
                    validOptions.add(validOptionsNode.asString());
                    break;
                }
                case LIST: {
                    for (ModelNode validOptionNode : validOptionsNode.asList()) {
                        validOptions.add(validOptionNode.asString());
                    }
                    break;
                }
            }
        }
        return validOptions;
    }

    private CartridgeResourceProperties createProperties(ModelNode propertiesNode) {
        if (propertiesNode == null || !propertiesNode.isDefined()) {
            return null;
        }
        CartridgeResourceProperties properties = new CartridgeResourceProperties();
        for (ModelNode propertyNode : propertiesNode.asList()) {
            CartridgeResourceProperty property = this.createProperty(propertyNode);
            String name = property.getName();
            if (StringUtils.isEmpty(name)) continue;
            properties.add(name, property);
        }
        return properties;
    }

    private CartridgeResourceProperty createProperty(ModelNode propertyNode) {
        String name = this.getAsString(propertyNode, "name");
        String description = this.getAsString(propertyNode, "description");
        String type = this.getAsString(propertyNode, "type");
        String value = this.getAsString(propertyNode, "value");
        return new CartridgeResourceProperty(name, type, description, value);
    }

    private List<EnvironmentVariableResourceDTO> createEnvironmentVariables(ModelNode dataNode) throws OpenShiftException {
        ArrayList<EnvironmentVariableResourceDTO> environmentVariables = new ArrayList<EnvironmentVariableResourceDTO>();
        for (ModelNode environmentVariableNode : dataNode.asList()) {
            EnvironmentVariableResourceDTO dto = this.createEnvironmentVariable(environmentVariableNode, null);
            if (dto == null) continue;
            environmentVariables.add(dto);
        }
        return environmentVariables;
    }

    private EnvironmentVariableResourceDTO createEnvironmentVariable(ModelNode environmentVariableNode, Messages messages) throws OpenShiftException {
        if (!environmentVariableNode.isDefined()) {
            return null;
        }
        String name = this.getAsString(environmentVariableNode, "name");
        String value = this.getAsString(environmentVariableNode, "value");
        Map<String, Link> links = this.createLinks(environmentVariableNode.get("links"));
        return new EnvironmentVariableResourceDTO(name, value, links, messages);
    }
}

