/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.Messages;
import com.openshift.client.cartridge.query.CartridgeNameRegexQuery;
import com.openshift.client.cartridge.query.ICartridgeQuery;
import com.openshift.internal.client.response.AbstractJsonDTOFactory;
import com.openshift.internal.client.response.DownloadableCartridgeSpec;
import com.openshift.internal.client.response.EnumDataType;
import com.openshift.internal.client.response.NamedCartridgeSpec;
import com.openshift.internal.client.response.OpenShiftJsonDTOFactory;
import com.openshift.internal.client.response.QuickstartDTO;
import com.openshift.internal.client.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickstartJsonDTOFactory
extends AbstractJsonDTOFactory {
    private static final Pattern CARTRIDGE_NAME_QUERY_PATTERN = Pattern.compile("\\*?([^|*]+)\\*?(\\|)?");
    private final Logger LOGGER = LoggerFactory.getLogger(OpenShiftJsonDTOFactory.class);

    @Override
    protected Object createData(EnumDataType dataType, Messages messages, ModelNode dataNode) {
        ArrayList<QuickstartDTO> quickstarts = new ArrayList<QuickstartDTO>();
        if (dataNode.getType() == ModelType.LIST) {
            for (ModelNode quickstartContainerNode : dataNode.asList()) {
                QuickstartDTO dto = this.createQuickstart(quickstartContainerNode.get("quickstart"));
                if (dto == null) continue;
                quickstarts.add(dto);
            }
        }
        return quickstarts;
    }

    private QuickstartDTO createQuickstart(ModelNode quickstartNode) {
        if (!this.isDefined(quickstartNode)) {
            return null;
        }
        String id = this.getAsString(quickstartNode, "id");
        String href = this.getAsString(quickstartNode, "href");
        String name = this.getAsString(quickstartNode, "name");
        String updated = this.getAsString(quickstartNode, "updated");
        String summary = this.getAsString(quickstartNode, "summary");
        List<ICartridgeQuery> cartridgeQueries = this.createCartridgeQueries(quickstartNode.get("cartridges"));
        String website = this.getAsString(quickstartNode, "website");
        List<String> tags = this.createTags(quickstartNode.get("tags"));
        String language = this.getAsString(quickstartNode, "language");
        String initialGitUrl = this.getAsString(quickstartNode, "initial_git_url");
        String provider = this.getAsString(quickstartNode, "provider");
        return new QuickstartDTO(id, href, name, updated, summary, cartridgeQueries, website, tags, language, initialGitUrl, provider);
    }

    protected List<ICartridgeQuery> createCartridgeQueries(ModelNode cartridgesNode) {
        if (!this.isDefined(cartridgesNode)) {
            return null;
        }
        if (cartridgesNode.getType() == ModelType.STRING) {
            return this.createCartridgesFromString(cartridgesNode.asString());
        }
        if (cartridgesNode.getType() == ModelType.LIST) {
            return this.createCartridgeQueriesFromJson(cartridgesNode);
        }
        return null;
    }

    private List<ICartridgeQuery> createCartridgesFromString(String cartridgesSpecs) {
        try {
            ModelNode cartridgesSpecsNode = ModelNode.fromJSONString((String)StringUtils.decodeQuotationMarks(cartridgesSpecs));
            return this.createCartridgeQueriesFromJson(cartridgesSpecsNode);
        }
        catch (IllegalArgumentException e) {
            return this.createCartridgeQueriesFromCommaDelimitedList(cartridgesSpecs);
        }
    }

    private List<ICartridgeQuery> createCartridgeQueriesFromJson(ModelNode cartridgesNode) {
        if (!this.isDefined(cartridgesNode)) {
            return null;
        }
        ArrayList<ICartridgeQuery> queries = new ArrayList<ICartridgeQuery>();
        for (ModelNode cartridgeSpec : cartridgesNode.asList()) {
            ICartridgeQuery query = this.createCartridgeQueryFromJson(cartridgeSpec);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    private ICartridgeQuery createCartridgeQueryFromJson(ModelNode cartridgeNode) {
        if (!this.isDefined(cartridgeNode)) {
            return null;
        }
        if (ModelType.STRING == cartridgeNode.getType()) {
            return this.createCartridgeQuery(cartridgeNode.asString());
        }
        if (ModelType.OBJECT == cartridgeNode.getType()) {
            if (cartridgeNode.has("name")) {
                return new NamedCartridgeSpec(cartridgeNode.get("name").asString());
            }
            if (cartridgeNode.has("url")) {
                String url = this.getAsString(cartridgeNode, "url");
                try {
                    return new DownloadableCartridgeSpec(url);
                }
                catch (MalformedURLException e) {
                    this.LOGGER.error("Could not create downloadable cartridge spec for Url {}", (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<ICartridgeQuery> createCartridgeQueriesFromCommaDelimitedList(String cartridgeSpecs) {
        ArrayList<ICartridgeQuery> queries = new ArrayList<ICartridgeQuery>();
        if (!StringUtils.isEmpty(cartridgeSpecs)) {
            for (String cartridgeSpec : cartridgeSpecs.split(",")) {
                queries.add(this.createCartridgeQuery(cartridgeSpec.trim()));
            }
        }
        return queries;
    }

    private ICartridgeQuery createCartridgeQuery(String cartridgeSpec) {
        try {
            return new DownloadableCartridgeSpec(new URL(cartridgeSpec));
        }
        catch (MalformedURLException e) {
            return new CartridgeNameRegexQuery(this.createNamePattern(cartridgeSpec));
        }
    }

    private String createNamePattern(String namePattern) {
        Matcher matcher = CARTRIDGE_NAME_QUERY_PATTERN.matcher(namePattern);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(".*");
            if (matcher.groupCount() >= 2 && !StringUtils.isEmpty(matcher.group(1))) {
                builder.append(matcher.group(1));
            }
            builder.append(".*");
            if (matcher.groupCount() < 2 || StringUtils.isEmpty(matcher.group(2))) continue;
            builder.append(matcher.group(2));
        }
        return builder.toString();
    }

    protected List<String> createTags(ModelNode tagsNode) {
        ArrayList<String> tags = new ArrayList<String>();
        if (this.isDefined(tagsNode)) {
            if (ModelType.LIST == tagsNode.getType()) {
                tags.addAll(this.getTags(tagsNode));
            } else if (ModelType.STRING == tagsNode.getType()) {
                tags.addAll(this.splitTags(tagsNode));
            }
        }
        return tags;
    }

    private Collection<String> getTags(ModelNode tagsNode) {
        ArrayList<String> tags = new ArrayList<String>();
        for (ModelNode node : tagsNode.asList()) {
            tags.add(node.asString());
        }
        return tags;
    }

    private Collection<? extends String> splitTags(ModelNode tagsNode) {
        return Arrays.asList(tagsNode.asString().split("\\, "));
    }
}

