/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.configuration;

import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.AbstractOpenshiftConfiguration;
import com.openshift.client.configuration.IOpenShiftConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class SystemProperties
extends AbstractOpenshiftConfiguration {
    protected static final String KEY_OPENSHIFT_TIMEOUT = "express.timeout";

    public SystemProperties(IOpenShiftConfiguration parentConfiguration) throws OpenShiftException, IOException {
        super(parentConfiguration);
    }

    @Override
    protected Properties getProperties(File file, Properties defaultProperties) {
        Properties properties = new Properties(defaultProperties);
        this.copySystemProperty("libra_domain", properties);
        this.copySystemProperty("libra_server", properties);
        this.copySystemProperty("default_rhlogin", properties);
        this.copySystemProperty("rhpassword", properties);
        this.copySystemProperty("client_id", properties);
        this.copySystemProperty(KEY_OPENSHIFT_TIMEOUT, properties);
        return properties;
    }

    private void copySystemProperty(String key, Properties properties) {
        Object value = System.getProperties().get(key);
        if (key.equals(KEY_OPENSHIFT_TIMEOUT) && value != null) {
            properties.put("timeout", value);
        } else if (value != null) {
            properties.put(key, value);
        }
    }
}

