/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IQuickstart;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.EmbeddableCartridge;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.client.cartridge.StandaloneCartridge;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.Quickstart;
import com.openshift.internal.client.UserResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.QuickstartDTO;
import com.openshift.internal.client.response.QuickstartJsonDTOFactory;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class APIResource
extends AbstractOpenShiftResource
implements IOpenShiftConnection {
    private static final String SYSPROPERTY_PROXY_PORT = "proxyPort";
    private static final String SYSPROPERTY_PROXY_HOST = "proxyHost";
    private static final String SYSPROPERTY_PROXY_SET = "proxySet";
    private final String login;
    private final String password;
    private UserResource user;
    private boolean doSSLChecks = false;
    private List<IDomain> domains;
    private List<IStandaloneCartridge> standaloneCartridges;
    private List<IEmbeddableCartridge> embeddableCartridges;
    private Map<String, IQuickstart> quickstartsByName;
    private final ExecutorService executorService;

    protected APIResource(String login, String password, IRestService service, Map<String, Link> links) {
        super(service, links, null);
        this.login = login;
        this.password = password;
        this.executorService = Executors.newFixedThreadPool(10);
    }

    protected final String getLogin() {
        return this.login;
    }

    protected final String getPassword() {
        return this.password;
    }

    @Override
    public String getServer() {
        return this.getService().getPlatformUrl();
    }

    @Override
    public void setEnableSSLCertChecks(boolean doSSLChecks) {
        this.doSSLChecks = doSSLChecks;
    }

    @Override
    @Deprecated
    public void setProxySet(boolean proxySet) {
        if (proxySet) {
            System.setProperty(SYSPROPERTY_PROXY_SET, "true");
        } else {
            System.setProperty(SYSPROPERTY_PROXY_SET, "false");
        }
    }

    @Override
    @Deprecated
    public void setProxyHost(String proxyHost) {
        System.setProperty(SYSPROPERTY_PROXY_HOST, proxyHost);
    }

    @Override
    @Deprecated
    public void setProxyPort(String proxyPort) {
        Assert.notNull(proxyPort);
        System.setProperty(SYSPROPERTY_PROXY_PORT, proxyPort);
    }

    @Override
    public IUser getUser() throws OpenShiftException {
        if (this.user == null) {
            this.user = new UserResource(this, new GetUserRequest().execute(), this.password);
        }
        return this.user;
    }

    @Override
    public List<IDomain> getDomains() throws OpenShiftException {
        if (this.domains == null) {
            this.domains = this.loadDomains();
        }
        return CollectionUtils.toUnmodifiableCopy(this.domains);
    }

    private List<IDomain> loadDomains() throws OpenShiftException {
        ArrayList<IDomain> domains = new ArrayList<IDomain>();
        for (DomainResourceDTO domainDTO : new ListDomainsRequest().execute()) {
            domains.add(new DomainResource(domainDTO, this));
        }
        return domains;
    }

    public IDomain getDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        for (IDomain domain : this.getDomains()) {
            if (!domain.getId().equals(id)) continue;
            return domain;
        }
        return null;
    }

    public IDomain getDefaultDomain() {
        List<IDomain> domains = this.getDomains();
        if (domains.size() > 0) {
            return domains.get(0);
        }
        return null;
    }

    public IDomain createDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        if (this.hasDomain(id)) {
            throw new OpenShiftException("Domain {0} already exists", id);
        }
        DomainResourceDTO domainDTO = new AddDomainRequest().execute(id);
        DomainResource domain = new DomainResource(domainDTO, this);
        this.domains.add(domain);
        return domain;
    }

    public IDomain showDomain(String id) throws OpenShiftException {
        Assert.notNull(id);
        DomainResourceDTO domainDTO = new ShowDomainRequest().execute(id);
        DomainResource domain = new DomainResource(domainDTO, this);
        return domain;
    }

    @Override
    public List<IStandaloneCartridge> getStandaloneCartridges() throws OpenShiftException {
        return this.getStandaloneCartridges(false);
    }

    @Override
    public List<IStandaloneCartridge> getStandaloneCartridges(boolean includeObsolete) throws OpenShiftException {
        return CollectionUtils.toUnmodifiableCopy(this.filterObsolete(includeObsolete, this.getOrLoadStandaloneCartridges()));
    }

    protected List<IStandaloneCartridge> getOrLoadStandaloneCartridges() throws OpenShiftException {
        if (this.standaloneCartridges == null) {
            this.loadCartridges();
        }
        return this.standaloneCartridges;
    }

    @Override
    public List<IEmbeddableCartridge> getEmbeddableCartridges() throws OpenShiftException {
        return this.getEmbeddableCartridges(false);
    }

    @Override
    public List<IEmbeddableCartridge> getEmbeddableCartridges(boolean includeObsolete) throws OpenShiftException {
        return CollectionUtils.toUnmodifiableCopy(this.filterObsolete(includeObsolete, this.getOrLoadEmbeddableCartridges()));
    }

    protected List<IEmbeddableCartridge> getOrLoadEmbeddableCartridges() throws OpenShiftException {
        if (this.embeddableCartridges == null) {
            this.loadCartridges();
        }
        return this.embeddableCartridges;
    }

    protected <C extends ICartridge> List<C> filterObsolete(boolean includeObsolete, List<C> allCartridges) {
        if (includeObsolete) {
            return allCartridges;
        }
        ArrayList<ICartridge> filteredList = new ArrayList<ICartridge>(allCartridges.size());
        for (ICartridge cartridge : allCartridges) {
            if (cartridge.isObsolete()) continue;
            filteredList.add(cartridge);
        }
        return filteredList;
    }

    @Override
    public List<ICartridge> getCartridges() {
        return this.getCartridges(false);
    }

    @Override
    public List<ICartridge> getCartridges(boolean includeObsolete) {
        List<IEmbeddableCartridge> embeddableCartridges = this.getOrLoadEmbeddableCartridges();
        List<IStandaloneCartridge> standaloneCartridges = this.getOrLoadStandaloneCartridges();
        ArrayList<ICartridge> cartridges = new ArrayList<ICartridge>(embeddableCartridges.size() + standaloneCartridges.size());
        cartridges.addAll(this.filterObsolete(includeObsolete, embeddableCartridges));
        cartridges.addAll(this.filterObsolete(includeObsolete, standaloneCartridges));
        return cartridges;
    }

    private void loadCartridges() throws OpenShiftException {
        Map<String, CartridgeResourceDTO> cartridgeDTOsByName = new GetCartridgesRequest().execute();
        this.standaloneCartridges = new ArrayList<IStandaloneCartridge>();
        this.embeddableCartridges = new ArrayList<IEmbeddableCartridge>();
        for (CartridgeResourceDTO cartridgeDTO : cartridgeDTOsByName.values()) {
            this.addCartridge(cartridgeDTO, this.standaloneCartridges, this.embeddableCartridges);
        }
    }

    private void addCartridge(CartridgeResourceDTO dto, List<IStandaloneCartridge> standaloneCartridges, List<IEmbeddableCartridge> embeddableCartridges) {
        switch (dto.getType()) {
            case STANDALONE: {
                standaloneCartridges.add(new StandaloneCartridge(dto.getName(), dto.getDisplayName(), dto.getDescription(), dto.getObsolete()));
                break;
            }
            case EMBEDDED: {
                embeddableCartridges.add(new EmbeddableCartridge(dto.getName(), dto.getDisplayName(), dto.getDescription(), dto.getObsolete()));
                break;
            }
        }
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.domains = null;
    }

    protected void removeDomain(IDomain domain) {
        this.domains.remove(domain);
    }

    protected boolean hasDomain(String name) throws OpenShiftException {
        return this.getDomain(name) != null;
    }

    @Override
    public List<IQuickstart> getQuickstarts() {
        if (this.quickstartsByName == null) {
            this.quickstartsByName = this.loadQuickstarts();
        }
        return CollectionUtils.toUnmodifiableCopy(this.quickstartsByName.values());
    }

    private Map<String, IQuickstart> loadQuickstarts() throws OpenShiftException {
        HashMap<String, IQuickstart> quickstarts = new HashMap<String, IQuickstart>();
        for (QuickstartDTO quickstartDTO : new ListQuickstartsRequest().execute()) {
            quickstarts.put(quickstartDTO.getName(), new Quickstart(quickstartDTO, this));
        }
        return quickstarts;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void disconnect() {
        this.standaloneCartridges = null;
        this.embeddableCartridges = null;
        this.domains = null;
        this.executorService.shutdownNow();
    }

    private class ListQuickstartsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ListQuickstartsRequest() throws OpenShiftException {
            super(APIResource.this, "LIST_QUICKSTARTS");
        }

        protected List<QuickstartDTO> execute() throws OpenShiftException {
            return (List)super.execute(-1, new QuickstartJsonDTOFactory(), Collections.<Parameter>emptyList(), Collections.<Parameter>emptyList(), new Parameter[0]);
        }
    }

    private class ShowDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ShowDomainRequest() throws OpenShiftException {
            super(APIResource.this, "SHOW_DOMAIN");
        }

        protected DomainResourceDTO execute(String id) throws OpenShiftException {
            List<Parameter> urlPathParameter = new AbstractOpenShiftResource.Parameters().add("name", id).toList();
            return (DomainResourceDTO)super.execute(-1, urlPathParameter, Collections.<Parameter>emptyList(), new Parameter[0]);
        }
    }

    private class GetCartridgesRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetCartridgesRequest() throws OpenShiftException {
            super(APIResource.this, "LIST_CARTRIDGES");
        }

        protected Map<String, CartridgeResourceDTO> execute() throws OpenShiftException {
            return (Map)super.execute(new Parameter[0]);
        }
    }

    private class GetUserRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private GetUserRequest() throws OpenShiftException {
            super(APIResource.this, "GET_USER");
        }

        protected UserResourceDTO execute() throws OpenShiftException {
            return (UserResourceDTO)super.execute(new Parameter[0]);
        }
    }

    private class ListDomainsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private ListDomainsRequest() throws OpenShiftException {
            super(APIResource.this, "LIST_DOMAINS");
        }

        protected List<DomainResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new Parameter[0]);
        }
    }

    private class AddDomainRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private AddDomainRequest() throws OpenShiftException {
            super(APIResource.this, "ADD_DOMAIN");
        }

        private DomainResourceDTO execute(String namespace) throws OpenShiftException {
            return (DomainResourceDTO)this.execute(new StringParameter("id", namespace));
        }
    }
}

