/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.restclient.model.IResource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(URLBuilder.class);
    private static final Map<String, String> kindMap = new HashMap<String, String>();
    private String baseUrl;
    private String kind;
    private String name;
    private Map<String, String> params = new HashMap<String, String>();
    private final Map<String, String> typeMappings;
    private String namespace;
    private String subResource;

    URLBuilder(URL baseUrl, Map<String, String> typeMappings, IResource resource) {
        this(baseUrl, typeMappings);
        this.resource(resource);
    }

    URLBuilder(URL baseUrl, Map<String, String> typeMappings) {
        this.baseUrl = baseUrl.toString().replaceAll("/*$", "");
        this.typeMappings = typeMappings;
    }

    URLBuilder namespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            return this;
        }
        if (this.typeMappingIsForV1Beta1()) {
            this.addParmeter("namespace", namespace);
        } else {
            this.namespace = namespace;
        }
        return this;
    }

    URLBuilder name(String name) {
        this.name = name;
        return this;
    }

    URLBuilder kind(String kind) {
        if (!kindMap.containsKey(kind)) {
            throw new IllegalArgumentException(String.format("There is no registered endpoint for kind %s", kind));
        }
        this.kind = kind;
        return this;
    }

    URLBuilder resource(IResource resource) {
        if (resource == null) {
            return this;
        }
        this.name = resource.getName();
        this.kind(resource.getKind());
        this.namespace(resource.getNamespace());
        return this;
    }

    URLBuilder addParmeter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    URLBuilder subresource(String value) {
        this.subResource = value;
        return this;
    }

    URL build() {
        StringBuilder url = new StringBuilder(this.baseUrl);
        if (this.kind == null) {
            throw new RuntimeException("Unable to build a URL because the ResourceKind is unknown");
        }
        if (this.typeMappingIsForV1Beta1()) {
            this.buildWithNamespaceAsQueryParam(url);
        } else {
            this.buildWithNamespaceInPath(url);
        }
        try {
            LOG.debug(String.format("Built url: %s", url.toString()));
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean typeMappingIsForV1Beta1() {
        String mapping = this.typeMappings.get(this.kind);
        return mapping.contains("v1beta1");
    }

    private void buildWithNamespaceInPath(StringBuilder url) {
        url.append("/").append(this.typeMappings.get(this.kind));
        if (this.namespace != null && !"Project".equals(this.kind)) {
            url.append("/namespaces/").append(this.namespace);
        }
        url.append("/").append(kindMap.get(this.kind));
        if (this.name != null) {
            url.append("/").append(this.name);
        }
        if (StringUtils.isNotBlank((String)this.subResource)) {
            url.append("/").append(this.subResource);
        }
        url = this.appendParameters(url);
    }

    private URL buildWithNamespaceAsQueryParam(StringBuilder url) {
        url.append("/").append(this.typeMappings.get(this.kind)).append("/").append(kindMap.get(this.kind));
        if (this.name != null) {
            url.append("/").append(this.name);
        }
        url = this.appendParameters(url);
        try {
            LOG.debug(String.format("Built url: %s", url.toString()));
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder appendParameters(StringBuilder url) {
        if (!this.params.isEmpty()) {
            url.append('?');
            Iterator<Map.Entry<String, String>> iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                try {
                    url.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (!iterator.hasNext()) continue;
                url.append((CharSequence)url.append('&'));
            }
        }
        return url;
    }

    static {
        kindMap.put("Build", "builds");
        kindMap.put("BuildConfig", "buildconfigs");
        kindMap.put("DeploymentConfig", "deploymentconfigs");
        kindMap.put("ImageStream", "imagestreams");
        kindMap.put("OAuthAccessToken", "oauthaccesstokens");
        kindMap.put("OAuthAuthorizeToken", "oauthauthorizetokens");
        kindMap.put("OAuthClient", "oauthclients");
        kindMap.put("OAuthClientAuthorization", "oauthclientauthorizations");
        kindMap.put("Policy", "policies");
        kindMap.put("PolicyBinding", "policybindings");
        kindMap.put("PersistentVolumeClaim", "persistentvolumeclaims");
        kindMap.put("Project", "projects");
        kindMap.put("ProjectRequest", "projectrequests");
        kindMap.put("Role", "roles");
        kindMap.put("RoleBinding", "rolebindings");
        kindMap.put("Route", "routes");
        kindMap.put("Template", "templates");
        kindMap.put("User", "users");
        kindMap.put("Event", "events");
        kindMap.put("LimitRange", "limitranges");
        kindMap.put("Pod", "pods");
        kindMap.put("ReplicationController", "replicationcontrollers");
        kindMap.put("ResourceQuota", "resourcequotas");
        kindMap.put("Service", "services");
        kindMap.put("Secret", "secrets");
        kindMap.put("ServiceAccount", "serviceaccounts");
        kindMap.put("TemplateConfig", "templateconfig");
        kindMap.put("ProcessedTemplates", "processedtemplates");
    }
}

