/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.authorization;

import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.util.Assert;
import com.openshift.internal.util.URIUtils;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.authorization.UnauthorizedException;
import java.net.URI;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class OpenShiftAuthorizationRedirectStrategy
extends DefaultRedirectStrategy {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES = "expires_in";
    private static final String ERROR = "error";
    private static final String ERROR_DETAILS = "error_details";
    private IAuthorizationContext authcontext;
    private IClient client;

    public OpenShiftAuthorizationRedirectStrategy(IClient client) {
        this.client = client;
        Assert.notNull(this.client);
    }

    public IAuthorizationContext getAuthorizationContext() {
        return this.authcontext;
    }

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        if (response.getStatusLine().getStatusCode() == 401) {
            AuthorizationDetails details = new AuthorizationDetails(response.getAllHeaders());
            throw new UnauthorizedException(details);
        }
        if (response.getStatusLine().getStatusCode() == 302) {
            Header locationHeader = response.getFirstHeader("Location");
            if (locationHeader == null) {
                return false;
            }
            URI locationURI = this.createLocationURI(locationHeader.getValue());
            Map<String, String> pairs = URIUtils.splitFragment(locationURI);
            if (pairs.containsKey(ACCESS_TOKEN)) {
                String token = pairs.get(ACCESS_TOKEN);
                IAuthorizationStrategy strategy = this.client.getAuthorizationStrategy();
                this.client.setAuthorizationStrategy(new TokenAuthorizationStrategy(token));
                this.authcontext = new AuthorizationContext(token, pairs.get(EXPIRES), this.client.getCurrentUser(), "Basic");
                this.client.setAuthorizationStrategy(strategy);
                return false;
            }
            Map<String, String> queryParams = URIUtils.splitQuery(locationURI.getQuery());
            if (queryParams.containsKey(ERROR)) {
                AuthorizationDetails details = new AuthorizationDetails(queryParams.get(ERROR), queryParams.get(ERROR_DETAILS));
                throw new UnauthorizedException(details);
            }
        }
        return super.isRedirected(request, response, context);
    }
}

