/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.server;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.server.ITemplateProcessing;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class ServerTemplateProcessing
implements ITemplateProcessing {
    private IClient client;

    public ServerTemplateProcessing(IClient client) {
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public ITemplate process(ITemplate template, String namespace) {
        return this.client.create(new TemplateConfigAdapter(template, namespace));
    }

    protected static class TemplateConfigAdapter
    extends KubernetesResource
    implements ITemplate {
        private ITemplate template;
        private String namespace;

        public TemplateConfigAdapter(ITemplate template, String namespace) {
            super(new ModelNode(), null, null);
            this.template = template;
            this.namespace = namespace;
        }

        @Override
        public String getName() {
            return this.template.getName();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getKind() {
            return "ProcessedTemplates";
        }

        @Override
        public String toString() {
            return this.template.toString();
        }

        @Override
        public Collection<IResource> getItems() {
            return this.template.getItems();
        }

        @Override
        public Map<String, IParameter> getParameters() {
            return this.template.getParameters();
        }

        @Override
        public void updateParameterValues(Collection<IParameter> parameters) {
            this.template.updateParameterValues(parameters);
        }

        @Override
        public Map<String, String> getObjectLabels() {
            return this.template.getObjectLabels();
        }

        @Override
        public void addObjectLabel(String key, String value) {
            this.template.addObjectLabel(key, value);
        }

        @Override
        public boolean isMatching(String text) {
            if (StringUtils.isEmpty((String)text)) {
                return true;
            }
            if (text.equals(this.getNamespace())) {
                return true;
            }
            if (this.template == null) {
                return false;
            }
            return this.template.isMatching(text);
        }
    }
}

