/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.build.CustomBuildStrategy;
import com.openshift.internal.restclient.model.build.DockerBuildStrategy;
import com.openshift.internal.restclient.model.build.GitBuildSource;
import com.openshift.internal.restclient.model.build.ImageChangeTrigger;
import com.openshift.internal.restclient.model.build.SourceBuildStrategy;
import com.openshift.internal.restclient.model.build.WebhookTrigger;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.build.IBuildSource;
import com.openshift.restclient.model.build.IBuildStrategy;
import com.openshift.restclient.model.build.IBuildTrigger;
import com.openshift.restclient.model.build.ICustomBuildStrategy;
import com.openshift.restclient.model.build.IDockerBuildStrategy;
import com.openshift.restclient.model.build.IGitBuildSource;
import com.openshift.restclient.model.build.IImageChangeTrigger;
import com.openshift.restclient.model.build.ISTIBuildStrategy;
import com.openshift.restclient.model.build.IWebhookTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class BuildConfig
extends KubernetesResource
implements IBuildConfig {
    private static final String BUILDCONFIG_SOURCE_CONTEXTDIR = "spec.source.contextDir";
    private static final String BUILDCONFIG_SOURCE_TYPE = "spec.source.type";
    private static final String BUILDCONFIG_SOURCE_URI = "spec.source.git.uri";
    private static final String BUILDCONFIG_SOURCE_REF = "spec.source.git.ref";
    public static final String BUILDCONFIG_TYPE = "spec.strategy.type";
    private static final String BUILDCONFIG_CUSTOM_IMAGE = "spec.strategy.customStrategy.image";
    private static final String BUILDCONFIG_CUSTOM_EXPOSEDOCKERSOCKET = "spec.strategy.customStrategy.exposeDockerSocket";
    private static final String BUILDCONFIG_CUSTOM_ENV = "spec.strategy.customStrategy.env";
    public static final String BUILDCONFIG_DOCKER_CONTEXTDIR = "spec.strategy.dockerStrategy.contextDir";
    public static final String BUILDCONFIG_DOCKER_NOCACHE = "spec.strategy.dockerStrategy.noCache";
    public static final String BUILDCONFIG_DOCKER_BASEIMAGE = "spec.strategy.dockerStrategy.baseImage";
    private static final String BUILDCONFIG_OUTPUT_REPO = "spec.output.to.name";
    private static final String BUILDCONFIG_STI_IMAGE = "spec.strategy.sourceStrategy.from.name";
    private static final String BUILDCONFIG_STI_SCRIPTS = "spec.strategy.sourceStrategy.scripts";
    private static final String BUILDCONFIG_STI_INCREMENTAL = "spec.strategy.sourceStrategy.incremental";
    private static final String BUILDCONFIG_STI_ENV = "spec.strategy.sourceStrategy.env";
    private static final String BUILDCONFIG_TRIGGERS = "spec.triggers";
    private static final String BUILD_CONFIG_WEBHOOK_GITHUB_SECRET = "github.secret";
    private static final String BUILD_CONFIG_WEBHOOK_GENERIC_SECRET = "generic.secret";
    private static final String BUILD_CONFIG_IMAGECHANGE_IMAGE = "imageChange.image";
    private static final String BUILD_CONFIG_IMAGECHANGE_NAME = "imageChange.from.name";
    private static final String BUILD_CONFIG_IMAGECHANGE_TAG = "imageChange.tag";

    public BuildConfig(ModelNode node, IClient client, Map<String, String[]> overrideProperties) {
        super(node, client, null);
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, client);
    }

    @Override
    public List<IBuildTrigger> getBuildTriggers() {
        ArrayList<IBuildTrigger> triggers = new ArrayList<IBuildTrigger>();
        List list = this.get(BUILDCONFIG_TRIGGERS).asList();
        String url = this.getClient() != null ? this.getClient().getResourceURI(this) : "";
        for (ModelNode node : list) {
            String type;
            switch (type = node.get("type").asString()) {
                case "generic": 
                case "Generic": {
                    triggers.add(new WebhookTrigger("Generic", this.asString(node, BUILD_CONFIG_WEBHOOK_GENERIC_SECRET), url));
                    break;
                }
                case "github": 
                case "GitHub": {
                    triggers.add(new WebhookTrigger("GitHub", this.asString(node, BUILD_CONFIG_WEBHOOK_GITHUB_SECRET), url));
                    break;
                }
                case "imageChange": 
                case "ImageChange": {
                    triggers.add(new ImageChangeTrigger("ImageChange", this.asString(node, BUILD_CONFIG_IMAGECHANGE_IMAGE), this.asString(node, BUILD_CONFIG_IMAGECHANGE_NAME), this.asString(node, BUILD_CONFIG_IMAGECHANGE_TAG)));
                    break;
                }
            }
        }
        return triggers;
    }

    @Override
    public void addBuildTrigger(IBuildTrigger trigger) {
        ModelNode triggers = this.get(BUILDCONFIG_TRIGGERS);
        ModelNode triggerNode = triggers.add();
        switch (trigger.getType()) {
            case "generic": 
            case "Generic": {
                if (!(trigger instanceof IWebhookTrigger)) {
                    throw new IllegalArgumentException("IBuildTrigger of type generic does not implement IWebhookTrigger");
                }
                IWebhookTrigger generic = (IWebhookTrigger)trigger;
                triggerNode.get(this.getPath(BUILD_CONFIG_WEBHOOK_GENERIC_SECRET)).set(generic.getSecret());
                break;
            }
            case "github": 
            case "GitHub": {
                if (!(trigger instanceof IWebhookTrigger)) {
                    throw new IllegalArgumentException("IBuildTrigger of type github does not implement IWebhookTrigger");
                }
                IWebhookTrigger github = (IWebhookTrigger)trigger;
                triggerNode.get(this.getPath(BUILD_CONFIG_WEBHOOK_GITHUB_SECRET)).set(github.getSecret());
                break;
            }
            case "imageChange": 
            case "ImageChange": {
                if (!(trigger instanceof IImageChangeTrigger)) {
                    throw new IllegalArgumentException("IBuildTrigger of type imageChange does not implement IImageChangeTrigger");
                }
                IImageChangeTrigger image = (IImageChangeTrigger)trigger;
                triggerNode.get(this.getPath(BUILD_CONFIG_IMAGECHANGE_IMAGE)).set(this.defaultIfNull(image.getImage()));
                triggerNode.get(this.getPath(BUILD_CONFIG_IMAGECHANGE_NAME)).set(this.defaultIfNull(image.getFrom()));
                triggerNode.get(this.getPath(BUILD_CONFIG_IMAGECHANGE_TAG)).set(StringUtils.defaultIfBlank((String)image.getTag(), (String)""));
            }
        }
        triggerNode.get("type").set(trigger.getType());
    }

    private String defaultIfNull(DockerImageURI uri) {
        if (uri == null) {
            return "";
        }
        return uri.toString();
    }

    @Override
    public String getOutputRepositoryName() {
        return this.asString(BUILDCONFIG_OUTPUT_REPO);
    }

    @Override
    public String getSourceURI() {
        return this.asString(BUILDCONFIG_SOURCE_URI);
    }

    @Override
    public <T extends IBuildSource> T getBuildSource() {
        switch (this.asString(BUILDCONFIG_SOURCE_TYPE)) {
            case "Git": {
                return (T)new GitBuildSource(this.asString(BUILDCONFIG_SOURCE_URI), this.asString(BUILDCONFIG_SOURCE_REF), this.asString(BUILDCONFIG_SOURCE_CONTEXTDIR));
            }
        }
        return null;
    }

    @Override
    public void setBuildSource(IBuildSource source) {
        switch (source.getType()) {
            case "Git": {
                if (!(source instanceof IGitBuildSource)) {
                    throw new IllegalArgumentException("IBuildSource of type Git does not implement IGitBuildSource");
                }
                IGitBuildSource git = (IGitBuildSource)source;
                this.set(BUILDCONFIG_SOURCE_REF, git.getRef());
            }
        }
        this.set(BUILDCONFIG_SOURCE_URI, source.getURI());
        this.set(BUILDCONFIG_SOURCE_TYPE, source.getType().toString());
        this.set(BUILDCONFIG_SOURCE_CONTEXTDIR, source.getContextDir());
    }

    @Override
    public void setBuildStrategy(IBuildStrategy strategy) {
        switch (strategy.getType()) {
            case "Custom": {
                if (!(strategy instanceof ICustomBuildStrategy)) {
                    throw new IllegalArgumentException("IBuildStrategy of type Custom does not implement ICustomBuildStrategy");
                }
                ICustomBuildStrategy custom = (ICustomBuildStrategy)strategy;
                if (custom.getImage() != null) {
                    this.set(BUILDCONFIG_CUSTOM_IMAGE, custom.getImage().toString());
                }
                this.set(BUILDCONFIG_CUSTOM_EXPOSEDOCKERSOCKET, custom.exposeDockerSocket());
                if (custom.getEnvironmentVariables() == null) break;
                this.setEnvMap(BUILDCONFIG_CUSTOM_ENV, custom.getEnvironmentVariables());
                break;
            }
            case "STI": 
            case "Source": {
                if (!(strategy instanceof ISTIBuildStrategy)) {
                    throw new IllegalArgumentException("IBuildStrategy of type Custom does not implement ISTIBuildStrategy");
                }
                ISTIBuildStrategy sti = (ISTIBuildStrategy)strategy;
                if (sti.getImage() != null) {
                    this.set(BUILDCONFIG_STI_IMAGE, sti.getImage().toString());
                }
                if (sti.getScriptsLocation() != null) {
                    this.set(BUILDCONFIG_STI_SCRIPTS, sti.getScriptsLocation());
                }
                this.set(BUILDCONFIG_STI_INCREMENTAL, sti.incremental());
                if (sti.getEnvironmentVariables() == null) break;
                this.setEnvMap(BUILDCONFIG_STI_ENV, sti.getEnvironmentVariables());
                break;
            }
            case "Docker": {
                if (!(strategy instanceof IDockerBuildStrategy)) {
                    throw new IllegalArgumentException("IBuildStrategy of type Custom does not implement IDockerBuildStrategy");
                }
                IDockerBuildStrategy docker = (IDockerBuildStrategy)strategy;
                if (docker.getBaseImage() != null) {
                    this.set(BUILDCONFIG_DOCKER_BASEIMAGE, docker.getBaseImage().toString());
                }
                if (docker.getContextDir() != null) {
                    this.set(BUILDCONFIG_DOCKER_CONTEXTDIR, docker.getContextDir());
                }
                this.set(BUILDCONFIG_DOCKER_NOCACHE, docker.isNoCache());
            }
        }
        this.set(BUILDCONFIG_TYPE, strategy.getType());
    }

    public void setOutput(DockerImageURI imageUri) {
    }

    @Override
    public <T extends IBuildStrategy> T getBuildStrategy() {
        switch (this.asString(BUILDCONFIG_TYPE)) {
            case "Custom": {
                return (T)new CustomBuildStrategy(this.asString(BUILDCONFIG_CUSTOM_IMAGE), this.asBoolean(BUILDCONFIG_CUSTOM_EXPOSEDOCKERSOCKET), this.getEnvMap(BUILDCONFIG_CUSTOM_ENV));
            }
            case "STI": 
            case "Source": {
                return (T)new SourceBuildStrategy(this.asString(BUILDCONFIG_STI_IMAGE), this.asString(BUILDCONFIG_STI_SCRIPTS), this.asBoolean(BUILDCONFIG_STI_INCREMENTAL), this.getEnvMap(BUILDCONFIG_STI_ENV));
            }
            case "Docker": {
                return (T)new DockerBuildStrategy(this.asString(BUILDCONFIG_DOCKER_CONTEXTDIR), this.asBoolean(BUILDCONFIG_DOCKER_NOCACHE), this.asString(BUILDCONFIG_DOCKER_BASEIMAGE));
            }
        }
        return null;
    }
}

