/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.Port;
import com.openshift.internal.restclient.model.deploy.DeploymentTrigger;
import com.openshift.internal.restclient.model.deploy.ImageChangeTrigger;
import com.openshift.internal.restclient.model.volume.EmptyDirVolume;
import com.openshift.restclient.IClient;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.deploy.IDeploymentTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;

public class DeploymentConfig
extends KubernetesResource
implements IDeploymentConfig {
    public static final String DEPLOYMENTCONFIG_CONTAINERS = "spec.template.spec.containers";
    private static final String VOLUMES = "spec.template.spec.volumes";
    private static final String DEPLOYMENTCONFIG_REPLICAS = "spec.replicas";
    private static final String DEPLOYMENTCONFIG_REPLICA_SELECTOR = "spec.selector";
    private static final String DEPLOYMENTCONFIG_TEMPLATE_LABELS = "spec.template.metadata.labels";
    private static final String DEPLOYMENTCONFIG_TRIGGERS = "spec.triggers";
    private static final String DEPLOYMENTCONFIG_STRATEGY = "spec.strategy.type";
    private static final String IMAGE = "image";
    private static final String ENV = "env";
    private static final String TYPE = "type";
    private final Map<String, String[]> propertyKeys;

    public DeploymentConfig(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public Map<String, String> getReplicaSelector() {
        return this.asMap(DEPLOYMENTCONFIG_REPLICA_SELECTOR);
    }

    @Override
    public void setReplicaSelector(Map<String, String> selector) {
        this.get(DEPLOYMENTCONFIG_REPLICA_SELECTOR).clear();
        this.set(DEPLOYMENTCONFIG_REPLICA_SELECTOR, selector);
    }

    @Override
    public void setReplicaSelector(String key, String value) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put(key, value);
        this.setReplicaSelector(selector);
    }

    public List<String> getTriggerTypes() {
        ArrayList<String> types = new ArrayList<String>();
        ModelNode triggers = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        for (ModelNode node : triggers.asList()) {
            types.add(node.get(TYPE).asString());
        }
        return types;
    }

    public List<String> getImageNames() {
        ArrayList<String> names = new ArrayList<String>();
        List containers = this.get(DEPLOYMENTCONFIG_CONTAINERS).asList();
        for (ModelNode container : containers) {
            names.add(container.get(IMAGE).asString());
        }
        return names;
    }

    @Override
    public int getReplicas() {
        return this.asInt(DEPLOYMENTCONFIG_REPLICAS);
    }

    @Override
    public void setReplicas(int replicas) {
        this.set(DEPLOYMENTCONFIG_REPLICAS, replicas);
    }

    @Override
    public void addTemplateLabel(String key, String value) {
        ModelNode labels = this.get(DEPLOYMENTCONFIG_TEMPLATE_LABELS);
        labels.get(key).set(value);
    }

    @Override
    public void addContainer(DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars) {
        this.addContainer(tag.getName(), tag, containerPorts, envVars, new ArrayList<String>());
    }

    @Override
    public void addContainer(String name, DockerImageURI tag, Set<IPort> containerPorts, Map<String, String> envVars, List<String> emptyDirVolumes) {
        ModelNode container = new ModelNode();
        container.get("name").set(name);
        container.get(this.getPath(IMAGE)).set(tag.getUriWithoutHost());
        if (emptyDirVolumes.size() > 0) {
            ModelNode volumeMounts = container.get("volumeMounts");
            ModelNode volumes = this.get(VOLUMES);
            for (String string : emptyDirVolumes) {
                EmptyDirVolume volume = new EmptyDirVolume(volumes.add());
                String volName = String.format("%s-%s", name, emptyDirVolumes.indexOf(string) + 1);
                volume.setName(volName);
                ModelNode volMount = volumeMounts.add();
                volMount.get("name").set(volName);
                volMount.get("mountPath").set(string);
            }
        }
        ModelNode ports = container.get(this.getPath("ports"));
        for (IPort port : containerPorts) {
            ModelNode modelNode = ports.add();
            new Port(modelNode, port);
        }
        if (!envVars.isEmpty()) {
            ModelNode env = container.get(this.getPath(ENV));
            for (Map.Entry entry : envVars.entrySet()) {
                ModelNode varNode = new ModelNode();
                varNode.get("name").set((String)entry.getKey());
                varNode.get("value").set((String)entry.getValue());
                env.add(varNode);
            }
        }
        this.get(DEPLOYMENTCONFIG_CONTAINERS).add(container);
    }

    @Override
    public IDeploymentTrigger addTrigger(String type) {
        ModelNode triggers = this.get(DEPLOYMENTCONFIG_TRIGGERS);
        ModelNode triggerNode = triggers.add();
        triggerNode.get(TYPE).set(type);
        switch (type) {
            case "ImageChange": {
                return new ImageChangeTrigger(triggerNode, this.propertyKeys);
            }
        }
        return new DeploymentTrigger(triggerNode, this.propertyKeys);
    }

    @Override
    public String getDeploymentStrategyType() {
        return this.asString(DEPLOYMENTCONFIG_STRATEGY);
    }
}

